/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.kernel.ia;

import ptolemy.data.expr.Parameter;
import ptolemy.domains.fsm.kernel.Transition;
import ptolemy.domains.fsm.kernel.ia.InterfaceAutomaton;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;

public class InterfaceAutomatonTransition
extends Transition {
    public StringAttribute label = new StringAttribute(this, "label");
    protected static final int _INPUT_TRANSITION = 0;
    protected static final int _OUTPUT_TRANSITION = 1;
    protected static final int _INTERNAL_TRANSITION = 2;

    public InterfaceAutomatonTransition(InterfaceAutomaton container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.outputActions.setVisibility(Settable.NONE);
        this.setActions.setVisibility(Settable.NONE);
        this.preemptive.setVisibility(Settable.NONE);
        this.reset.setVisibility(Settable.NONE);
        this.guardExpression.setVisibility(Settable.NONE);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        super.attributeChanged(attribute);
        if (attribute == this.label) {
            String labelString = this.label.getExpression();
            String name = labelString.substring(0, labelString.length() - 1);
            if (labelString.endsWith("?")) {
                this.setGuardExpression(name + "_isPresent");
                this.outputActions.setExpression("");
            } else if (labelString.endsWith("!")) {
                this.setGuardExpression("true");
                this.outputActions.setExpression(name + "=true");
            } else if (labelString.endsWith(";")) {
                InterfaceAutomaton container = (InterfaceAutomaton)this.getContainer();
                if (container.getAttribute(name) == null) {
                    try {
                        new Parameter(container, name);
                    }
                    catch (NameDuplicationException exception) {
                        throw new InternalErrorException("InterfaceAutomatonTransition.attributeChanged:\nCannot create Parameter for internal transition:\n" + exception.getMessage());
                    }
                }
                this.setGuardExpression("true");
                this.outputActions.setExpression(name + "=true");
            } else {
                throw new IllegalActionException("InterfaceAutomatonTransition.attributeChanged: The argument " + this.label + " does not end with ? " + "or ! or ;");
            }
        }
    }

    @Override
    public String getLabel() {
        String labelStr = this.label.getExpression();
        if (labelStr == null) {
            labelStr = "";
        }
        return labelStr;
    }

    public int getType() {
        String labelString = this.label.getExpression();
        if (labelString.endsWith("?")) {
            return 0;
        }
        if (labelString.endsWith("!")) {
            return 1;
        }
        if (labelString.endsWith(";")) {
            return 2;
        }
        throw new InternalErrorException("InterfaceAutomatonTransition.getType: The label does not end with ? or ! or ;");
    }

    @Override
    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        if (!(container instanceof InterfaceAutomaton) && container != null) {
            throw new IllegalActionException((Nameable)container, this, "Transition can only be contained by instances of InterfaceAutomaton.");
        }
        super.setContainer(container);
    }

    public void setTriggerExpression(String expression) {
        throw new UnsupportedOperationException("InterfaceAutomatonTransition.setTriggerExpression: The trigger expression is not used in InterfaceAutomaton, so this method should not be called.");
    }
}

