/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.kernel;

import java.util.Iterator;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoRoomException;
import ptolemy.actor.Receiver;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.UnknownResultException;
import ptolemy.domains.fsm.kernel.AbstractActionsAttribute;
import ptolemy.domains.fsm.kernel.ChoiceAction;
import ptolemy.domains.fsm.kernel.Transition;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class OutputActionsAttribute
extends AbstractActionsAttribute
implements ChoiceAction {
    public OutputActionsAttribute(Workspace workspace) {
        super(workspace);
    }

    public OutputActionsAttribute(Transition transition, String name) throws IllegalActionException, NameDuplicationException {
        super(transition, name);
    }

    @Override
    public void execute() throws IllegalActionException {
        super.execute();
        if (this._destinations != null) {
            Iterator destinations = this._destinations.iterator();
            Iterator channels = this._numbers.iterator();
            Iterator parseTrees = this._parseTrees.iterator();
            while (destinations.hasNext()) {
                Token token;
                NamedObj nextDestination = (NamedObj)destinations.next();
                if (!(nextDestination instanceof IOPort)) {
                    throw new IllegalActionException((Nameable)this, "Destination is not an IOPort: " + nextDestination.getFullName());
                }
                IOPort destination = (IOPort)nextDestination;
                boolean isInput = destination.isInput();
                Integer channel = (Integer)channels.next();
                ASTPtRootNode parseTree = (ASTPtRootNode)parseTrees.next();
                try {
                    token = this._parseTreeEvaluator.evaluateParseTree(parseTree, this._scope);
                }
                catch (IllegalActionException ex) {
                    throw new IllegalActionException((Nameable)this, ex, "Expression invalid.");
                }
                try {
                    if (token == null) continue;
                    Receiver[][] localReceivers = destination.getReceivers();
                    if (channel != null) {
                        int chanelValue = channel;
                        destination.send(chanelValue, token);
                        if (isInput) {
                            localReceivers[chanelValue][0].put(token);
                        }
                        if (!this._debugging) continue;
                        this._debug(this.getFullName() + " port: " + destination.getName() + " channel: " + chanelValue + ", token: " + token);
                        continue;
                    }
                    destination.broadcast(token);
                    if (isInput) {
                        for (int i = 0; i < localReceivers.length; ++i) {
                            localReceivers[i][0].put(token);
                        }
                    }
                    if (!this._debugging) continue;
                    this._debug(this.getFullName() + " port: " + destination.getName() + " token: " + token);
                }
                catch (NoRoomException ex) {
                    throw new IllegalActionException((Nameable)this, "Cannot complete action: " + ex.getMessage());
                }
                catch (UnknownResultException ex) {
                }
            }
        }
    }

    @Override
    protected NamedObj _getDestination(String name) throws IllegalActionException {
        Transition transition = (Transition)this.getContainer();
        if (transition == null) {
            throw new IllegalActionException((Nameable)this, "Action has no container transition.");
        }
        Entity fsm = (Entity)transition.getContainer();
        if (fsm == null) {
            throw new IllegalActionException((Nameable)this, transition, "Transition has no container.");
        }
        IOPort port = (IOPort)fsm.getPort(name);
        if (port == null) {
            throw new IllegalActionException((Nameable)fsm, this, "Cannot find port with name: " + name);
        }
        if (!port.isOutput()) {
            throw new IllegalActionException((Nameable)fsm, this, "The port is not an output port: " + name);
        }
        return port;
    }
}

