/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.de.lib;

import java.util.List;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.domains.de.lib.DETransformer;
import ptolemy.graph.Inequality;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class Sampler
extends DETransformer {
    public TypedIOPort trigger;
    public Parameter initialValue;
    protected Token[] _lastInputs;

    public Sampler(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setMultiport(true);
        this.output.setMultiport(true);
        this.output.setTypeAtLeast(this.input);
        this.trigger = new TypedIOPort(this, "trigger", true, false);
        this.initialValue = new Parameter(this, "initialValue");
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-20\" width=\"60\" height=\"40\" style=\"fill:white\"/>\n<polyline points=\"0,20 0,0\"/>\n<polyline points=\"-30,-0 -10,0 10,-7\"/>\n<polyline points=\"10,0 30,0\"/>\n</svg>\n");
        StringAttribute cardinality = new StringAttribute(this.trigger, "_cardinal");
        cardinality.setExpression("SOUTH");
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Sampler newObject = (Sampler)super.clone(workspace);
        newObject.output.setTypeAtLeast(newObject.input);
        newObject._lastInputs = null;
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        int i;
        super.fire();
        int inputWidth = this.input.getWidth();
        int outputWidth = this.output.getWidth();
        int commonWidth = Math.min(inputWidth, outputWidth);
        if (this._lastInputs == null || this._lastInputs.length != inputWidth) {
            this._lastInputs = new Token[inputWidth];
        }
        for (i = 0; i < commonWidth; ++i) {
            while (this.input.hasToken(i)) {
                this._lastInputs[i] = this.input.get(i);
            }
        }
        for (i = commonWidth; i < inputWidth; ++i) {
            while (this.input.hasToken(i)) {
                this.input.get(i);
            }
        }
        if (this.trigger.hasToken(0)) {
            this.trigger.get(0);
            for (i = 0; i < commonWidth; ++i) {
                if (this._lastInputs[i] == null) continue;
                this.output.send(i, this._lastInputs[i]);
            }
        }
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        super.prefire();
        if (this.trigger.getWidth() > 0) {
            return this.trigger.hasToken(0);
        }
        return false;
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        if (this.initialValue.getToken() != null) {
            this._lastInputs = new Token[this.input.getWidth()];
            for (int i = 0; i < this.input.getWidth(); ++i) {
                this._lastInputs[i] = this.initialValue.getToken();
            }
        } else {
            this._lastInputs = null;
        }
        super.preinitialize();
    }

    @Override
    public List typeConstraintList() {
        List typeConstraints = super.typeConstraintList();
        try {
            if (this.initialValue.getToken() != null) {
                Inequality ineq = new Inequality(this.initialValue.getTypeTerm(), this.input.getTypeTerm());
                typeConstraints.add(ineq);
                ineq = new Inequality(this.input.getTypeTerm(), this.initialValue.getTypeTerm());
                typeConstraints.add(ineq);
            }
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("Bad initialValue value!");
        }
        return typeConstraints;
    }
}

