/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.de.lib;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import ptolemy.actor.gui.Placeable;
import ptolemy.actor.lib.Source;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.StringAttribute;

public class EventButton
extends Source
implements Placeable {
    public StringAttribute text = new StringAttribute(this, "text");
    private JButton _button;
    private boolean _buttonPressed;
    private Container _container;
    private JFrame _frame;
    private EventButton _self;

    public EventButton(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.text.setExpression("Click!");
        this.output.setTypeEquals(BaseType.GENERAL);
        this._self = this;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this._buttonPressed) {
            this.output.broadcast(new Token());
        }
    }

    public Color getBackground() {
        return this._button.getBackground();
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._buttonPressed = false;
        if (this._button == null) {
            this.place(this._container);
        }
        if (this._frame != null) {
            this._frame.setVisible(true);
            this._frame.toFront();
        }
    }

    @Override
    public void place(Container container) {
        this._container = container;
        this._button = new JButton(this.text.getExpression());
        this._button.addActionListener(new ButtonListener());
        if (this._container == null) {
            System.out.println("Container is null");
            this._frame = new JFrame(this.getFullName());
            this._frame.getContentPane().add(this._button);
        } else {
            this._container.add(this._button);
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this._buttonPressed) {
            this._buttonPressed = false;
        }
        return super.postfire();
    }

    public void setBackground(Color background) {
        this._button.setBackground(background);
    }

    @Override
    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        super.setContainer(container);
        if (container == null) {
            this._remove();
        }
    }

    private void _remove() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EventButton.this._button != null) {
                    if (EventButton.this._container != null) {
                        EventButton.this._container.remove(EventButton.this._button);
                        EventButton.this._container.invalidate();
                        EventButton.this._container.repaint();
                    } else if (EventButton.this._frame != null) {
                        EventButton.this._frame.dispose();
                    }
                }
            }
        });
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                EventButton.this._buttonPressed = true;
                EventButton.this.getDirector().fireAtCurrentTime(EventButton.this._self);
            }
            catch (IllegalActionException ex) {
                throw new InternalErrorException(ex.getMessage());
            }
        }
    }
}

