/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ddf.kernel;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.FiringEvent;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.QueueReceiver;
import ptolemy.actor.Receiver;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.actor.util.DFUtilities;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.BaseType;
import ptolemy.domains.ddf.kernel.ActorEnablingStatus;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class DDFDirector
extends Director {
    public Parameter iterations;
    public Parameter maximumReceiverCapacity;
    public Parameter runUntilDeadlockInOneIteration;
    private boolean _isTypeResolutionDisabled = false;
    private boolean _firedOne = false;
    private int _iterationCount = 0;
    private boolean _runUntilDeadlock;
    private HashMap _actorsInfo = new HashMap();
    private LinkedList _actorsToCheckNumberOfFirings = new LinkedList();
    private Set _disabledActors = new HashSet();

    public DDFDirector() throws IllegalActionException, NameDuplicationException {
        this._init();
    }

    public DDFDirector(Workspace workspace) throws IllegalActionException, NameDuplicationException {
        super(workspace);
        this._init();
    }

    public DDFDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._init();
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.runUntilDeadlockInOneIteration) {
            this._runUntilDeadlock = ((BooleanToken)this.runUntilDeadlockInOneIteration.getToken()).booleanValue();
            if (this._runUntilDeadlock && this._isTopLevel()) {
                throw new IllegalActionException((Nameable)this, "Cannot set runUntilDeadlockInOneIteration to be true if this DDFDirector is at top level. Instead you should set the parameter iterations to be zero to achieve the same effect.");
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void disableTypeResolution(boolean flag) {
        this._isTypeResolutionDisabled = flag;
    }

    @Override
    public void fire() throws IllegalActionException {
        boolean repeatBasicIteration = false;
        if (this._debugging) {
            this._debug("DDFDirector.fire()");
        }
        block0: do {
            LinkedList<Actor> toBeFiredActors = new LinkedList<Actor>();
            LinkedList<Actor> minimaxActors = new LinkedList<Actor>();
            int minimaxSize = Integer.MAX_VALUE;
            for (Actor actor : ((TypedCompositeActor)this.getContainer()).deepEntityList()) {
                if (this._disabledActors.contains(actor)) continue;
                ActorInfo actorInfo = (ActorInfo)this._actorsInfo.get(actor);
                ActorEnablingStatus status = actorInfo.status;
                if (status == ActorEnablingStatus.ENABLED_NOT_DEFERRABLE) {
                    toBeFiredActors.add(actor);
                }
                if (status != ActorEnablingStatus.ENABLED_DEFERRABLE) continue;
                int newSize = actorInfo.maximumNumberOfTokens;
                if (newSize < minimaxSize) {
                    minimaxActors.clear();
                    minimaxActors.add(actor);
                    minimaxSize = newSize;
                    continue;
                }
                if (newSize != minimaxSize) continue;
                minimaxActors.add(actor);
            }
            this._firedOne = false;
            for (Actor actor : toBeFiredActors) {
                boolean isActorFired = this._fireActor(actor);
                this._firedOne = isActorFired || this._firedOne;
            }
            if (!this._firedOne) {
                for (Actor minimaxActor : minimaxActors) {
                    boolean isActorFired = this._fireActor(minimaxActor);
                    this._firedOne = isActorFired || this._firedOne;
                }
            }
            if (this._runUntilDeadlock) {
                repeatBasicIteration = this._firedOne;
                continue;
            }
            if (this._firedOne) {
                Iterator actors = this._actorsToCheckNumberOfFirings.iterator();
                repeatBasicIteration = false;
                while (actors.hasNext()) {
                    Actor actor;
                    actor = (Actor)actors.next();
                    if (actor.getContainer() == null) {
                        actors.remove();
                        continue;
                    }
                    ActorInfo actorInfo = (ActorInfo)this._actorsInfo.get(actor);
                    int firingsDone = actorInfo.numberOfFirings;
                    int requiredFirings = actorInfo.requiredFiringsPerIteration;
                    if (firingsDone >= requiredFirings) continue;
                    repeatBasicIteration = true;
                    continue block0;
                }
            } else {
                if (this._debugging) {
                    this._debug("deadlock detected");
                }
                repeatBasicIteration = false;
            }
        } while (repeatBasicIteration && !this._stopRequested);
    }

    @Override
    public void initialize() throws IllegalActionException {
        this._iterationCount = 0;
        this._runUntilDeadlock = ((BooleanToken)this.runUntilDeadlockInOneIteration.getToken()).booleanValue();
        this._actorsToCheckNumberOfFirings.clear();
        this._disabledActors.clear();
        super.initialize();
        for (IOPort outputPort : ((Actor)((Object)this.getContainer())).outputPortList()) {
            for (int i = 0; i < outputPort.getWidthInside(); ++i) {
                while (outputPort.hasTokenInside(i)) {
                    Token token = outputPort.getInside(i);
                    if (this._debugging) {
                        this._debug("transferring initial tokens from " + outputPort.getFullName());
                    }
                    outputPort.send(i, token);
                }
            }
        }
        if (this._debugging) {
            this._debug("DDFDirector.initialize() finished.");
        }
    }

    @Override
    public void initialize(Actor actor) throws IllegalActionException {
        super.initialize(actor);
        this._updateConnectedActorsStatus(actor);
        ActorInfo actorInfo = (ActorInfo)this._actorsInfo.get(actor);
        actorInfo.requiredFiringsPerIteration = 0;
        Variable requiredFiringsPerIteration = (Variable)((Entity)((Object)actor)).getAttribute("requiredFiringsPerIteration");
        if (requiredFiringsPerIteration != null) {
            Token token = requiredFiringsPerIteration.getToken();
            if (token instanceof IntToken) {
                int value = ((IntToken)token).intValue();
                if (value > 0) {
                    actorInfo.requiredFiringsPerIteration = value;
                }
                this._actorsToCheckNumberOfFirings.add(actor);
            } else {
                throw new IllegalActionException((Nameable)this, actor, "The variable requiredFiringsPerIteration must contain an IntToken.");
            }
        }
    }

    @Override
    public void invalidateResolvedTypes() {
        if (!this._isTypeResolutionDisabled) {
            super.invalidateResolvedTypes();
        }
    }

    public void merge(DDFDirector insideDirector) {
        this._disabledActors.addAll(insideDirector._disabledActors);
        this._actorsToCheckNumberOfFirings.addAll(insideDirector._actorsToCheckNumberOfFirings);
        this._actorsInfo.putAll(insideDirector._actorsInfo);
    }

    @Override
    public Receiver newReceiver() {
        QueueReceiver receiver = new QueueReceiver();
        try {
            int capacity = ((IntToken)this.maximumReceiverCapacity.getToken()).intValue();
            if (capacity > 0) {
                receiver.setCapacity(capacity);
            }
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return receiver;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        boolean isDeadlocked;
        int iterationsValue = ((IntToken)this.iterations.getToken()).intValue();
        ++this._iterationCount;
        if (iterationsValue > 0 && this._iterationCount >= iterationsValue) {
            if (this._debugging) {
                this._debug("iteration limit reached");
            }
            return false;
        }
        boolean bl = isDeadlocked = !this._firedOne;
        if (isDeadlocked && this._isEmbedded()) {
            block0: for (IOPort inputPort : ((Actor)((Object)this.getContainer())).inputPortList()) {
                Receiver[][] deepReceivers = inputPort.deepGetReceivers();
                for (int i = 0; i < deepReceivers.length; ++i) {
                    for (int j = 0; j < deepReceivers[i].length; ++j) {
                        QueueReceiver deepReceiver = (QueueReceiver)deepReceivers[i][j];
                        IOPort port = deepReceiver.getContainer();
                        if (port.getContainer() == this.getContainer()) continue;
                        int tokenConsumptionRate = this._getTokenConsumptionRate(deepReceiver);
                        if (deepReceiver.size() >= tokenConsumptionRate) continue;
                        isDeadlocked = false;
                        continue block0;
                    }
                }
            }
        }
        return super.postfire() && !isDeadlocked;
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("DDFDirector.prefire()\niterationCount " + this._iterationCount);
        }
        super.prefire();
        Actor container = (Actor)((Object)this.getContainer());
        for (IOPort inputPort : container.inputPortList()) {
            if (inputPort instanceof ParameterPort) continue;
            int[] rate = this._getTokenConsumptionRate(inputPort);
            for (int i = 0; i < inputPort.getWidth(); ++i) {
                if (rate[i] < 0 || inputPort.hasToken(i, rate[i])) continue;
                if (this._debugging) {
                    this._debug("Channel " + i + " of port " + inputPort.getFullName() + " does not have enough tokens: " + rate[i] + ". Prefire returns false.");
                }
                if (this._debugging) {
                    this._debug("DDFDirector.prefire() returns false.");
                }
                return false;
            }
        }
        for (Actor actor : this._actorsToCheckNumberOfFirings) {
            ActorInfo actorInfo = (ActorInfo)this._actorsInfo.get(actor);
            actorInfo.numberOfFirings = 0;
        }
        if (this._debugging) {
            this._debug("DDFDirector.prefire() returns true.");
        }
        return true;
    }

    @Override
    public String[] suggestedModalModelDirectors() {
        String[] defaultSuggestions = new String[]{"ptolemy.domains.fsm.kernel.MultirateFSMDirector", "ptolemy.domains.hdf.kernel.HDFFSMDirector", "ptolemy.domains.fsm.kernel.FSMDirector", "ptolemy.domains.fsm.kernel.NonStrictFSMDirector"};
        return defaultSuggestions;
    }

    @Override
    public boolean supportMultirateFiring() {
        return true;
    }

    @Override
    public boolean transferInputs(IOPort port) throws IllegalActionException {
        if (this._debugging) {
            this._debug("Calling transferInputs on port: " + port.getFullName());
        }
        if (!port.isInput() || !port.isOpaque()) {
            throw new IllegalActionException((Nameable)this, port, "Attempted to transferInputs on a port is not an opaque input port.");
        }
        boolean wasTransferred = false;
        int[] rate = this._getTokenConsumptionRate(port);
        for (int i = 0; i < port.getWidth(); ++i) {
            try {
                if (rate[i] >= 0) {
                    for (int k = 0; k < rate[i]; ++k) {
                        Token t;
                        if (port.hasToken(i)) {
                            t = port.get(i);
                            if (this._debugging) {
                                this._debug(this.getName(), "transferring input from channel " + i + " of input port " + port.getName());
                            }
                        } else {
                            throw new IllegalActionException((Nameable)this, port, "Channel " + i + "should consume " + rate[i] + " tokens, but there were only " + k + " tokens available. Maybe the rate" + " is set wrong?");
                        }
                        port.sendInside(i, t);
                        wasTransferred = true;
                    }
                    continue;
                }
                if (!port.hasToken(i)) continue;
                Token token = port.get(i);
                if (this._debugging) {
                    this._debug(this.getName(), "transferring input from channel " + i + " of port " + port.getName());
                }
                port.sendInside(i, token);
                wasTransferred = true;
                continue;
            }
            catch (NoTokenException ex) {
                throw new InternalErrorException(this, (Throwable)ex, null);
            }
        }
        for (IOPort insideSinkPort : port.insideSinkPortList()) {
            Actor actor = (Actor)((Object)insideSinkPort.getContainer());
            if (this.getContainer() == actor) continue;
            ActorInfo actorInfo = (ActorInfo)this._actorsInfo.get(actor);
            if (actorInfo == null) {
                actorInfo = new ActorInfo();
                this._actorsInfo.put(actor, actorInfo);
            }
            actorInfo.status = this._getActorStatus(actor);
        }
        return wasTransferred;
    }

    @Override
    public boolean transferOutputs(IOPort port) throws IllegalActionException {
        if (this._debugging) {
            this._debug("Calling transferOutputs on port: " + port.getFullName());
        }
        if (!port.isOutput() || !port.isOpaque()) {
            throw new IllegalActionException((Nameable)this, port, "Attempted to transferOutputs on a port that is not an opaque output port.");
        }
        boolean wasTransferred = false;
        int[] rate = this._getTokenProductionRate(port);
        for (int i = 0; i < port.getWidthInside(); ++i) {
            try {
                if (rate[i] >= 0) {
                    for (int k = 0; k < rate[i]; ++k) {
                        Token token;
                        if (port.hasTokenInside(i)) {
                            token = port.getInside(i);
                            if (this._debugging) {
                                this._debug(this.getName(), "transferring output from channel " + i + " of port " + port.getName());
                            }
                        } else {
                            throw new IllegalActionException((Nameable)this, port, "Channel " + i + " should produce " + rate[i] + " tokens, but there were only " + k + " tokens available. Maybe the rate" + " is set wrong?");
                        }
                        port.send(i, token);
                        wasTransferred = true;
                    }
                    continue;
                }
                while (port.hasTokenInside(i)) {
                    Token token = port.getInside(i);
                    if (this._debugging) {
                        this._debug(this.getName(), "transferring output from channel " + i + " of port " + port.getName());
                    }
                    port.send(i, token);
                    wasTransferred = true;
                }
                continue;
            }
            catch (NoTokenException ex) {
                throw new InternalErrorException(this, (Throwable)ex, null);
            }
        }
        return wasTransferred;
    }

    protected boolean _fireActor(Actor actor) throws IllegalActionException {
        if (this._debugging) {
            this._debug(new FiringEvent(this, actor, FiringEvent.BEFORE_ITERATE));
        }
        int returnValue = actor.iterate(1);
        if (this._debugging) {
            this._debug(new FiringEvent(this, actor, FiringEvent.AFTER_ITERATE));
        }
        this._updateConnectedActorsStatus(actor);
        if (returnValue == 2) {
            if (this._debugging) {
                this._debug("Actor " + ((NamedObj)((Object)actor)).getFullName() + " is disabled.");
            }
            this._disabledActors.add(actor);
            this._actorsToCheckNumberOfFirings.remove(actor);
        }
        boolean fired = false;
        if (returnValue != 1) {
            fired = true;
            if (this._actorsToCheckNumberOfFirings.contains(actor)) {
                ActorInfo actorInfo = (ActorInfo)this._actorsInfo.get(actor);
                ++actorInfo.numberOfFirings;
            }
        }
        return fired;
    }

    protected ActorEnablingStatus _getActorStatus(Actor actor) throws IllegalActionException {
        if (!this._isEnabled(actor)) {
            if (this._debugging) {
                this._debug(((NamedObj)((Object)actor)).getName() + ": " + ActorEnablingStatus.NOT_ENABLED);
            }
            return ActorEnablingStatus.NOT_ENABLED;
        }
        if (this._isDeferrable(actor)) {
            if (this._debugging) {
                this._debug(((NamedObj)((Object)actor)).getName() + ": " + ActorEnablingStatus.ENABLED_DEFERRABLE);
            }
            return ActorEnablingStatus.ENABLED_DEFERRABLE;
        }
        if (this._debugging) {
            this._debug(((NamedObj)((Object)actor)).getName() + ": " + ActorEnablingStatus.ENABLED_NOT_DEFERRABLE);
        }
        return ActorEnablingStatus.ENABLED_NOT_DEFERRABLE;
    }

    protected boolean _isDeferrable(Actor actor) throws IllegalActionException {
        boolean deferrable = false;
        int maxSize = 0;
        for (IOPort outputPort : actor.outputPortList()) {
            Receiver[][] farReceivers = outputPort.getRemoteReceivers();
            for (int i = 0; i < farReceivers.length; ++i) {
                for (int j = 0; j < farReceivers[i].length; ++j) {
                    int tokenConsumptionRate;
                    QueueReceiver farReceiver = (QueueReceiver)farReceivers[i][j];
                    IOPort port = farReceiver.getContainer();
                    if (port.getContainer() == outputPort.getContainer() || (tokenConsumptionRate = this._getTokenConsumptionRate(farReceiver)) < 0 || farReceiver.size() < tokenConsumptionRate) continue;
                    deferrable = true;
                    if (farReceiver.size() <= maxSize) continue;
                    maxSize = farReceiver.size();
                }
            }
        }
        if (deferrable) {
            ActorInfo actorInfo = (ActorInfo)this._actorsInfo.get(actor);
            actorInfo.maximumNumberOfTokens = maxSize;
        }
        return deferrable;
    }

    protected boolean _isEnabled(Actor actor) throws IllegalActionException {
        for (IOPort inputPort : actor.inputPortList()) {
            int[] rate = this._getTokenConsumptionRate(inputPort);
            for (int i = 0; i < inputPort.getWidth(); ++i) {
                if (rate[i] <= 0 || inputPort.hasToken(i, rate[i])) continue;
                return false;
            }
        }
        return true;
    }

    protected void _updateConnectedActorsStatus(Actor actor) throws IllegalActionException {
        ActorInfo actorInfo;
        for (ComponentPort port : ((Entity)((Object)actor)).portList()) {
            for (Port deepConnectedPort : port.deepConnectedPortList()) {
                ActorInfo actorInfo2;
                Actor connectedActor = (Actor)((Object)deepConnectedPort.getContainer());
                if (this.getContainer() == connectedActor) continue;
                if (this._actorsInfo.containsKey(connectedActor)) {
                    actorInfo2 = (ActorInfo)this._actorsInfo.get(connectedActor);
                } else {
                    actorInfo2 = new ActorInfo();
                    this._actorsInfo.put(connectedActor, actorInfo2);
                }
                actorInfo2.status = this._getActorStatus(connectedActor);
            }
        }
        if (this._actorsInfo.containsKey(actor)) {
            actorInfo = (ActorInfo)this._actorsInfo.get(actor);
        } else {
            actorInfo = new ActorInfo();
            this._actorsInfo.put(actor, actorInfo);
        }
        actorInfo.status = this._getActorStatus(actor);
    }

    private int[] _getTokenConsumptionRate(IOPort port) throws IllegalActionException {
        Token token;
        int[] rate = new int[port.getWidth()];
        if (port.getContainer() != this.getContainer()) {
            Arrays.fill(rate, 1);
        } else {
            Arrays.fill(rate, -1);
        }
        Variable rateVariable = DFUtilities.getRateVariable(port, "tokenConsumptionRate");
        if (rateVariable != null && (token = rateVariable.getToken()) != null) {
            if (token instanceof ArrayToken) {
                Token[] tokens = ((ArrayToken)token).arrayValue();
                for (int i = 0; i < port.getWidth(); ++i) {
                    if (i >= tokens.length) continue;
                    rate[i] = ((IntToken)tokens[i]).intValue();
                }
            } else {
                Arrays.fill(rate, ((IntToken)token).intValue());
            }
        }
        return rate;
    }

    private int _getTokenConsumptionRate(Receiver receiver) throws IllegalActionException {
        int tokenConsumptionRate;
        IOPort port = receiver.getContainer();
        Variable rateVariable = null;
        Token token = null;
        Receiver[][] portReceivers = null;
        if (port.isOutput()) {
            rateVariable = DFUtilities.getRateVariable(port, "tokenProductionRate");
            portReceivers = port.getInsideReceivers();
            if (rateVariable == null) {
                int tokenConsumptionRate2 = -1;
                return tokenConsumptionRate2;
            }
            token = rateVariable.getToken();
            if (token == null) {
                int tokenConsumptionRate3 = -1;
                return tokenConsumptionRate3;
            }
        }
        if (port.isInput()) {
            rateVariable = DFUtilities.getRateVariable(port, "tokenConsumptionRate");
            portReceivers = port.getReceivers();
            if (rateVariable == null) {
                int tokenConsumptionRate4 = 1;
                return tokenConsumptionRate4;
            }
            token = rateVariable.getToken();
            if (token == null) {
                int tokenConsumptionRate5 = 1;
                return tokenConsumptionRate5;
            }
        }
        if (token instanceof ArrayToken) {
            Token[] tokens = ((ArrayToken)token).arrayValue();
            int channelIndex = 0;
            block0: for (int m = 0; m < portReceivers.length; ++m) {
                for (int n = 0; n < portReceivers[m].length; ++n) {
                    if (receiver != portReceivers[m][n]) continue;
                    channelIndex = m;
                    break block0;
                }
            }
            tokenConsumptionRate = ((IntToken)tokens[channelIndex]).intValue();
        } else {
            tokenConsumptionRate = ((IntToken)token).intValue();
        }
        return tokenConsumptionRate;
    }

    private int[] _getTokenProductionRate(IOPort port) throws IllegalActionException {
        Token token;
        if (port.getContainer() != this.getContainer()) {
            throw new IllegalActionException((Nameable)this, "The port in the argument is not an output port of the container of " + this.getName());
        }
        int[] rate = new int[port.getWidthInside()];
        Arrays.fill(rate, -1);
        Variable rateVariable = DFUtilities.getRateVariable(port, "tokenProductionRate");
        if (rateVariable != null && (token = rateVariable.getToken()) != null) {
            if (token instanceof ArrayToken) {
                Token[] tokens = ((ArrayToken)token).arrayValue();
                if (tokens.length < port.getWidthInside()) {
                    throw new IllegalActionException((Nameable)this, "The length of tokenProductionRate array is less than the port inside width.");
                }
                for (int i = 0; i < port.getWidthInside(); ++i) {
                    if (i >= tokens.length) continue;
                    rate[i] = ((IntToken)tokens[i]).intValue();
                }
            } else {
                Arrays.fill(rate, ((IntToken)token).intValue());
            }
        }
        return rate;
    }

    private void _init() throws IllegalActionException, NameDuplicationException {
        this.iterations = new Parameter(this, "iterations");
        this.iterations.setTypeEquals(BaseType.INT);
        this.iterations.setToken(new IntToken(0));
        this.maximumReceiverCapacity = new Parameter(this, "maximumReceiverCapacity");
        this.maximumReceiverCapacity.setTypeEquals(BaseType.INT);
        this.maximumReceiverCapacity.setToken(new IntToken(0));
        this.runUntilDeadlockInOneIteration = new Parameter(this, "runUntilDeadlockInOneIteration");
        this.runUntilDeadlockInOneIteration.setTypeEquals(BaseType.BOOLEAN);
        this.runUntilDeadlockInOneIteration.setToken(new BooleanToken(false));
    }

    private static class ActorInfo {
        public ActorEnablingStatus status;
        public int numberOfFirings;
        public int maximumNumberOfTokens;
        public int requiredFiringsPerIteration;

        private ActorInfo() {
        }
    }
}

