/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.domains.ct.kernel.CTStepSizeControlActor;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class ThresholdMonitor
extends TypedAtomicActor
implements CTStepSizeControlActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public TypedIOPort output;
    public Parameter thresholdWidth;
    public Parameter thresholdCenter;
    private double _thWidth;
    private double _thCenter;
    private boolean _first;
    private boolean _accurate;
    private double _upperBound;
    private double _lowerBound;
    private double _lastInput;
    private double _thisInput;

    public ThresholdMonitor(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setMultiport(false);
        this.input.setTypeEquals(BaseType.DOUBLE);
        new Parameter((NamedObj)this.input, "signalType", new StringToken("CONTINUOUS"));
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setMultiport(false);
        this.output.setTypeEquals(BaseType.BOOLEAN);
        new Parameter((NamedObj)this.output, "signalType", new StringToken("DISCRETE"));
        this._thWidth = 0.01;
        this.thresholdWidth = new Parameter((NamedObj)this, "thresholdWidth", new DoubleToken(this._thWidth));
        this._thCenter = 0.0;
        this.thresholdCenter = new Parameter((NamedObj)this, "thresholdCenter", new DoubleToken(this._thCenter));
        this._lowerBound = -0.005;
        this._upperBound = 0.005;
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.thresholdCenter || attribute == this.thresholdWidth) {
            this._thCenter = ((DoubleToken)this.thresholdCenter.getToken()).doubleValue();
            this._thWidth = Math.abs(((DoubleToken)this.thresholdWidth.getToken()).doubleValue());
            this._lowerBound = this._thCenter - this._thWidth / 2.0;
            this._upperBound = this._thCenter + this._thWidth / 2.0;
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this._debug("Monitor" + this.getFullName() + " fired.");
        this._thisInput = ((DoubleToken)this.input.get(0)).doubleValue();
        if (this._thisInput <= this._upperBound && this._thisInput >= this._lowerBound) {
            this.output.send(0, new BooleanToken(true));
        } else {
            this.output.send(0, new BooleanToken(false));
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._first = true;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        super.postfire();
        if (this.input.hasToken(0)) {
            this._thisInput = ((DoubleToken)this.input.get(0)).doubleValue();
        }
        if (this._thisInput <= this._upperBound && this._thisInput >= this._lowerBound) {
            this.output.send(0, new BooleanToken(true));
        } else {
            this.output.send(0, new BooleanToken(false));
        }
        this._lastInput = this._thisInput;
        this._first = false;
        return true;
    }

    @Override
    public double predictedStepSize() {
        return Double.MAX_VALUE;
    }

    @Override
    public double refinedStepSize() {
        CTDirector dir = (CTDirector)this.getDirector();
        if (!this._accurate) {
            return 0.5 * dir.getCurrentStepSize();
        }
        return dir.getCurrentStepSize();
    }

    @Override
    public boolean isStateAccurate() {
        return true;
    }

    @Override
    public boolean isOutputAccurate() {
        if (!this._first && (this._lastInput >= this._upperBound && this._thisInput <= this._lowerBound || this._lastInput <= this._lowerBound && this._thisInput >= this._upperBound)) {
            this._debug(this.getFullName() + "one step crosses the threshold" + "cutting the step size in half.");
            this._accurate = false;
            return false;
        }
        this._accurate = true;
        return true;
    }
}

