/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.lib;

import ptolemy.actor.Actor;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.util.Time;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class EventSource
extends TypedAtomicActor {
    public TypedIOPort output = new TypedIOPort(this, "output", false, true);
    public Parameter offsets;
    public Parameter period;
    public Parameter values;
    private transient Time _cycleStartTime;
    private transient double[] _offsets;
    private transient int _phase;
    private transient Time _nextOutputTime;

    public EventSource(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        new Parameter((NamedObj)this.output, "signalType", new StringToken("DISCRETE"));
        this.period = new Parameter(this, "period");
        this.period.setExpression("2.0");
        this.period.setTypeEquals(BaseType.DOUBLE);
        this.offsets = new Parameter(this, "offsets");
        this.offsets.setExpression("{0.0, 1.0}");
        this.offsets.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.attributeChanged(this.offsets);
        this.values = new Parameter(this, "values");
        this.values.setExpression("{1, 0}");
        this.output.setTypeAtLeast(ArrayType.elementType(this.values));
        this.attributeChanged(this.values);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.offsets) {
            ArrayToken offsetsValue = (ArrayToken)this.offsets.getToken();
            this._offsets = new double[offsetsValue.length()];
            double previous = 0.0;
            for (int i = 0; i < offsetsValue.length(); ++i) {
                this._offsets[i] = ((DoubleToken)offsetsValue.getElement(i)).doubleValue();
                if (this._offsets[i] < previous) {
                    throw new IllegalActionException((Nameable)this, "Value of offsets is not nondecreasing and nonnegative.");
                }
                previous = this._offsets[i];
            }
        } else if (attribute == this.period) {
            double periodValue = ((DoubleToken)this.period.getToken()).doubleValue();
            if (periodValue <= 0.0) {
                throw new IllegalActionException((Nameable)this, "Period is required to be positive.  Period given: " + periodValue);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        EventSource newObject = (EventSource)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType(newObject.values));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.output.send(0, ((ArrayToken)this.values.getToken()).getElement(this._phase));
    }

    @Override
    public synchronized void initialize() throws IllegalActionException {
        super.initialize();
        this._cycleStartTime = this.getDirector().getModelTime();
        this._phase = 0;
        this._nextOutputTime = this._cycleStartTime.add(this._offsets[0]);
        this.getDirector().fireAt((Actor)this, this._nextOutputTime);
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        CTDirector director = (CTDirector)this.getDirector();
        boolean result = director.getModelTime().compareTo(this._nextOutputTime) == 0;
        return result && super.prefire();
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        CTDirector director = (CTDirector)this.getDirector();
        double periodValue = ((DoubleToken)this.period.getToken()).doubleValue();
        ++this._phase;
        if (this._phase >= this._offsets.length) {
            this._phase = 0;
            this._cycleStartTime = this._cycleStartTime.add(periodValue);
        }
        if (this._offsets[this._phase] >= periodValue) {
            throw new IllegalActionException((Nameable)this, "Offset number " + this._phase + " with value " + this._offsets[this._phase] + " must be less than the " + "period, which is " + periodValue);
        }
        this._nextOutputTime = this._cycleStartTime.add(this._offsets[this._phase]);
        director.fireAt((Actor)this, this._nextOutputTime);
        return true;
    }
}

