/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.unit;

import java.util.ArrayList;
import java.util.HashMap;

public class UnitUtilities {
    private static HashMap _indexTable = new HashMap();
    private static int _categories = 0;
    private static ArrayList _categoryList = new ArrayList();

    private UnitUtilities() {
    }

    public static int[] addUnitsArray(int[] units1, int[] units2) {
        int[] result;
        boolean isUnitless1 = UnitUtilities.isUnitless(units1);
        boolean isUnitless2 = UnitUtilities.isUnitless(units2);
        if (isUnitless1 && isUnitless2) {
            return null;
        }
        if (isUnitless1) {
            return UnitUtilities.copyUnitsArray(units2);
        }
        if (isUnitless2) {
            return UnitUtilities.copyUnitsArray(units1);
        }
        int units1Length = units1.length;
        int units2Length = units2.length;
        if (units1Length < units2Length) {
            result = new int[units2Length];
            System.arraycopy(units2, 0, result, 0, units2Length);
            for (int i = 0; i < units1Length; ++i) {
                int n = i;
                result[n] = result[n] + units1[i];
            }
        } else {
            result = new int[units1Length];
            System.arraycopy(units1, 0, result, 0, units1Length);
            for (int i = 0; i < units2Length; ++i) {
                int n = i;
                result[n] = result[n] + units2[i];
            }
        }
        if (UnitUtilities.isUnitless(result)) {
            return null;
        }
        return result;
    }

    public static boolean areUnitArraysEqual(int[] units1, int[] units2) {
        int i;
        boolean isUnitless1 = UnitUtilities.isUnitless(units1);
        boolean isUnitless2 = UnitUtilities.isUnitless(units2);
        if (isUnitless1 && isUnitless2) {
            return true;
        }
        if (isUnitless1 || isUnitless2) {
            return false;
        }
        int units1Length = units1.length;
        int units2Length = units2.length;
        int shorterLength = Math.min(units1Length, units2Length);
        for (i = 0; i < shorterLength; ++i) {
            if (units1[i] == units2[i]) continue;
            return false;
        }
        for (i = shorterLength; i < units1Length; ++i) {
            if (units1[i] == 0) continue;
            return false;
        }
        for (i = shorterLength; i < units2Length; ++i) {
            if (units2[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static ArrayList categoryList() {
        return new ArrayList(_categoryList);
    }

    public static int[] copyUnitsArray(int[] units) {
        if (UnitUtilities.isUnitless(units)) {
            return null;
        }
        int length = units.length;
        int[] newUnits = new int[length];
        System.arraycopy(units, 0, newUnits, 0, length);
        return newUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBaseUnitName(int categoryIndex) {
        HashMap hashMap = _indexTable;
        synchronized (hashMap) {
            if (categoryIndex < 0 || categoryIndex >= _categories) {
                return "unknown";
            }
            String categoryName = (String)_categoryList.get(categoryIndex);
            if (categoryName != null) {
                return categoryName;
            }
            return "unknown";
        }
    }

    public static int getNumCategories() {
        return _categories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getUnitCategoryIndex(String categoryName) {
        HashMap hashMap = _indexTable;
        synchronized (hashMap) {
            Integer index = (Integer)_indexTable.get(categoryName);
            if (index == null) {
                return -1;
            }
            return index;
        }
    }

    public static boolean isUnitless(int[] exponents) {
        if (exponents != null) {
            for (int i = 0; i < exponents.length; ++i) {
                if (exponents[i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static int[] newUnitArrayInCategory(int index) {
        int[] units = new int[index + 1];
        units[index] = 1;
        return units;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerUnitCategory(String categoryName) {
        HashMap hashMap = _indexTable;
        synchronized (hashMap) {
            Integer index = (Integer)_indexTable.get(categoryName);
            if (index != null) {
                return;
            }
            index = _categories;
            _indexTable.put(categoryName, index);
            ++_categories;
            _categoryList.add(categoryName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetUnitCategories() {
        HashMap hashMap = _indexTable;
        synchronized (hashMap) {
            _indexTable.clear();
            _categories = 0;
            _categoryList.clear();
        }
    }

    public static int[] subtractUnitsArray(int[] units1, int[] units2) {
        int[] negation = null;
        if (!UnitUtilities.isUnitless(units2)) {
            int length = units2.length;
            negation = new int[length];
            for (int i = 0; i < length; ++i) {
                negation[i] = -units2[i];
            }
        }
        return UnitUtilities.addUnitsArray(units1, negation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String summarizeUnitCategories() {
        HashMap hashMap = _indexTable;
        synchronized (hashMap) {
            return "The registered categories are: " + _categories + " " + _categoryList.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unitsString(int[] units) {
        HashMap hashMap = _indexTable;
        synchronized (hashMap) {
            if (UnitUtilities.isUnitless(units)) {
                return "";
            }
            StringBuffer positiveUnits = new StringBuffer();
            StringBuffer negativeUnits = new StringBuffer();
            boolean justOnePositive = true;
            boolean justOneNegative = true;
            for (int i = 0; i < units.length; ++i) {
                int j;
                int exponent = units[i];
                if (exponent == 0) continue;
                String baseString = null;
                baseString = UnitUtilities.getBaseUnitName(i);
                if (exponent > 0) {
                    for (j = 0; j < exponent; ++j) {
                        if (positiveUnits.length() == 0) {
                            positiveUnits = new StringBuffer(baseString);
                            continue;
                        }
                        positiveUnits.append(" * " + baseString);
                        justOnePositive = false;
                    }
                    continue;
                }
                for (j = 0; j < -exponent; ++j) {
                    if (negativeUnits.length() == 0) {
                        negativeUnits = new StringBuffer(baseString);
                        continue;
                    }
                    negativeUnits.append(" * " + baseString);
                    justOneNegative = false;
                }
            }
            if (positiveUnits.length() == 0 && negativeUnits.length() == 0) {
                return "";
            }
            if (positiveUnits.length() == 0) {
                positiveUnits = new StringBuffer("1");
            } else if (!justOnePositive) {
                positiveUnits = new StringBuffer("(" + positiveUnits + ")");
            }
            if (negativeUnits.length() == 0) {
                return positiveUnits.toString();
            }
            if (justOneNegative) {
                return positiveUnits.toString() + " / " + negativeUnits.toString();
            }
            return positiveUnits.toString() + " / (" + negativeUnits.toString() + ")";
        }
    }
}

