/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.unit;

import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import ptolemy.data.expr.Parameter;
import ptolemy.data.unit.BaseUnit;
import ptolemy.data.unit.ParseException;
import ptolemy.data.unit.UParser;
import ptolemy.data.unit.Unit;
import ptolemy.data.unit.UnitExpr;
import ptolemy.data.unit.UnitSystem;
import ptolemy.data.unit.UnitUtilities;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLParser;
import ptolemy.util.FileUtilities;

public class UnitLibrary {
    public static final Unit Identity;
    private static boolean _debug;
    private static int _numCats;
    private static UParser _parser;
    private static Vector _unitsLibrary;

    public static void addToLibrary(Unit unit) {
        _unitsLibrary.add(unit);
    }

    public static Unit getBaseUnit(int catNum) {
        Vector library = UnitLibrary.getLibrary();
        for (int i = 0; i < library.size(); ++i) {
            int[] ltype;
            Unit lUnit = (Unit)library.elementAt(i);
            if (lUnit.getScale() != 1.0 || (double)(ltype = lUnit.getType())[catNum] != 1.0) continue;
            return lUnit;
        }
        return null;
    }

    public static Unit getClosestUnit(Unit unit) {
        Vector possibles = UnitLibrary.getUnitsByType(unit);
        if (possibles.isEmpty()) {
            return null;
        }
        double scalarDistance = Double.MAX_VALUE;
        Unit retv = null;
        for (int i = 0; i < possibles.size(); ++i) {
            Unit possible = (Unit)possibles.elementAt(i);
            double distance = Math.abs(possible.getScale() - unit.getScale());
            if (!(distance < scalarDistance)) continue;
            scalarDistance = distance;
            retv = possible;
        }
        return retv;
    }

    public static Vector getLibrary() {
        return _unitsLibrary;
    }

    public static int getNumCategories() {
        return _numCats;
    }

    public static UParser getParser() {
        return _parser;
    }

    public static Unit getUnit(Unit unit) {
        Unit retv = UnitLibrary.getClosestUnit(unit);
        if (retv == null) {
            return null;
        }
        if (Math.abs(retv.getScale() - unit.getScale()) < 1.0E-8) {
            return retv;
        }
        return null;
    }

    public static Unit getUnitByName(String name) {
        Vector library = UnitLibrary.getLibrary();
        for (int i = 0; i < library.size(); ++i) {
            Unit lUnit = (Unit)library.elementAt(i);
            Vector names = lUnit.getLabels();
            for (int j = 0; j < names.size(); ++j) {
                if (!((String)names.elementAt(j)).equals(name)) continue;
                return lUnit;
            }
        }
        return null;
    }

    public static Vector getUnitsByType(Unit unit) {
        Vector<Unit> retv = new Vector<Unit>();
        Vector library = UnitLibrary.getLibrary();
        for (int i = 0; i < library.size(); ++i) {
            Unit lUnit = (Unit)library.elementAt(i);
            if (!lUnit.hasSameType(unit)) continue;
            retv.add(lUnit);
        }
        return retv;
    }

    static {
        _debug = false;
        _parser = new UParser();
        MoMLParser momlParser = new MoMLParser();
        UnitSystem us = null;
        try {
            URL inURL;
            NamedObj container = new NamedObj();
            momlParser.setContext(container);
            URL base = inURL = FileUtilities.nameToURL("$CLASSPATH/ptolemy/data/unit/SI.xml", null, null);
            momlParser.parse(base, inURL);
            us = (UnitSystem)container.getAttribute("SI");
        }
        catch (Throwable throwable) {
            throw new InternalErrorException(null, throwable, "Failed to initialize statics in UnitLibrary");
        }
        _unitsLibrary = new Vector();
        _numCats = UnitUtilities.getNumCategories();
        Identity = new Unit("Identity");
        _unitsLibrary.add(Identity);
        Iterator oldStyleUnits = us.attributeList().iterator();
        UnitLibrary enclosingObject = new UnitLibrary();
        Vector<UnitNameExprPair> pairs = new Vector<UnitNameExprPair>();
        while (oldStyleUnits.hasNext()) {
            Object oldStyleUnit = oldStyleUnits.next();
            if (oldStyleUnit instanceof BaseUnit) {
                BaseUnit baseUnit = (BaseUnit)oldStyleUnit;
                Unit basicUnit = new Unit(baseUnit);
                UnitLibrary.addToLibrary(basicUnit);
                continue;
            }
            if (!(oldStyleUnit instanceof Parameter)) continue;
            String name = ((Parameter)oldStyleUnit).getName();
            String expr = ((Parameter)oldStyleUnit).getExpression();
            UnitLibrary unitLibrary = enclosingObject;
            unitLibrary.getClass();
            UnitNameExprPair pair = unitLibrary.new UnitNameExprPair(name, expr);
            pairs.add(pair);
        }
        boolean madeChange = true;
        while (!pairs.isEmpty() && madeChange) {
            madeChange = false;
            Iterator iter = pairs.iterator();
            while (iter.hasNext()) {
                UnitNameExprPair pair = (UnitNameExprPair)iter.next();
                String expr = pair.getUExpr();
                try {
                    UnitExpr uExpr = _parser.parseUnitExpr(expr);
                    Unit unit = uExpr.reduce().getSingleUnit();
                    if (unit == null) continue;
                    unit.setPrimaryLabel(pair.getName());
                    iter.remove();
                    madeChange = true;
                    UnitLibrary.addToLibrary(unit);
                }
                catch (ParseException e1) {}
            }
        }
        if (_debug) {
            Vector units = UnitLibrary.getLibrary();
            for (int i = 0; i < units.size(); ++i) {
                System.out.println(((Unit)units.elementAt(i)).toString());
            }
        }
    }

    private class UnitNameExprPair {
        private String _name;
        private String _uExpr;

        public UnitNameExprPair(String n, String ue) {
            this._name = n;
            this._uExpr = ue;
        }

        public String getName() {
            return this._name;
        }

        public String getUExpr() {
            return this._uExpr;
        }
    }
}

