/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.unit;

import java.util.Iterator;
import java.util.Vector;
import ptolemy.actor.IOPort;
import ptolemy.data.unit.Unit;
import ptolemy.data.unit.UnitLibrary;
import ptolemy.data.unit.UnitPresentation;
import ptolemy.data.unit.UnitTerm;

public class UnitExpr
implements UnitPresentation {
    boolean _isFlat = false;
    Vector _uTerms = new Vector();

    public UnitExpr() {
    }

    public UnitExpr(IOPort ioPort) {
        UnitTerm uTerm = new UnitTerm();
        uTerm.setVariable(ioPort.getContainer().getName() + "." + ioPort.getName());
        this._uTerms.add(uTerm);
    }

    public void addUnitTerm(UnitTerm uTerm) {
        this._uTerms.add(uTerm);
    }

    public UnitExpr copy() {
        UnitExpr retv = new UnitExpr();
        Vector<UnitTerm> newUTerms = new Vector<UnitTerm>();
        for (int i = 0; i < this._uTerms.size(); ++i) {
            UnitTerm term = (UnitTerm)this._uTerms.elementAt(i);
            newUTerms.add(term.copy());
        }
        retv._setUTerms(newUTerms);
        return retv;
    }

    @Override
    public String descriptiveForm() {
        Iterator iter = this._uTerms.iterator();
        StringBuffer retv = new StringBuffer(((UnitTerm)iter.next()).descriptiveForm());
        while (iter.hasNext()) {
            retv.append(" " + ((UnitTerm)iter.next()).descriptiveForm());
        }
        return retv.toString();
    }

    public Unit getSingleUnit() {
        if (this._uTerms.size() == 1 && ((UnitTerm)this._uTerms.elementAt(0)).isUnit()) {
            return ((UnitTerm)this._uTerms.elementAt(0)).getUnit();
        }
        return null;
    }

    public Vector getUTerms() {
        return this._uTerms;
    }

    public UnitExpr invert() {
        UnitExpr retv = new UnitExpr();
        Vector<UnitTerm> myUTerms = new Vector<UnitTerm>();
        for (int i = 0; i < this._uTerms.size(); ++i) {
            myUTerms.add(((UnitTerm)this._uTerms.elementAt(i)).invert());
        }
        retv._setUTerms(myUTerms);
        return retv;
    }

    public UnitExpr reduce() {
        this._flatten();
        Unit reductionUnit = UnitLibrary.Identity.copy();
        Vector<UnitTerm> newUTerms = new Vector<UnitTerm>();
        for (int i = 0; i < this._uTerms.size(); ++i) {
            UnitTerm unitTerm = (UnitTerm)this._uTerms.elementAt(i);
            if (unitTerm.isUnit()) {
                reductionUnit = reductionUnit.multiplyBy(unitTerm.getUnit().pow(unitTerm.getExponent()));
                continue;
            }
            newUTerms.add(unitTerm);
        }
        newUTerms.add(new UnitTerm(reductionUnit));
        UnitExpr retv = new UnitExpr();
        retv._setUTerms(newUTerms);
        return retv;
    }

    @Override
    public String toString() {
        StringBuffer retv = new StringBuffer("UnitExpr:[");
        if (this._uTerms.size() > 0) {
            retv.append(((UnitTerm)this._uTerms.elementAt(0)).toString());
            for (int i = 1; i < this._uTerms.size(); ++i) {
                retv.append(" " + ((UnitTerm)this._uTerms.elementAt(i)).toString());
            }
        }
        retv.append("]");
        return retv.toString();
    }

    protected void _setUTerms(Vector uTerms) {
        this._uTerms = uTerms;
    }

    private void _flatten() {
        if (this._isFlat) {
            return;
        }
        Vector<UnitTerm> newUTerms = new Vector<UnitTerm>();
        for (int i = 0; i < this._uTerms.size(); ++i) {
            UnitTerm unitTerm = (UnitTerm)this._uTerms.elementAt(i);
            if (unitTerm.isUnitExpr()) {
                UnitExpr uExpr = unitTerm.getUnitExpr();
                if (uExpr == null) continue;
                uExpr._flatten();
                newUTerms.addAll(uExpr.getUTerms());
                continue;
            }
            newUTerms.add(unitTerm);
        }
        this._isFlat = true;
        this._setUTerms(newUTerms);
    }
}

