/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.unit;

import java.util.Vector;
import ptolemy.data.unit.EquationVisitor;
import ptolemy.data.unit.Unit;
import ptolemy.data.unit.UnitConstraint;
import ptolemy.data.unit.UnitExpr;
import ptolemy.data.unit.UnitLibrary;
import ptolemy.data.unit.UnitPresentation;
import ptolemy.data.unit.UnitTerm;
import ptolemy.kernel.util.IllegalActionException;

public class UnitEquation
extends UnitConstraint
implements UnitPresentation {
    public UnitEquation(UnitExpr lhs, UnitExpr rhs) {
        super(lhs, "=", rhs);
    }

    public static boolean areSatisfied(Vector equations) {
        for (int i = 0; i < equations.size(); ++i) {
            if (((UnitEquation)equations.elementAt(i)).isSatisfied()) continue;
            return false;
        }
        return true;
    }

    public UnitEquation canonicalize() {
        UnitExpr lhsUExpr = this.getLhs();
        UnitExpr rhsUExpr = this.getRhs();
        UnitExpr newLeftUExpr = new UnitExpr();
        UnitExpr newRightUExpr = new UnitExpr();
        Vector leftUTerms = lhsUExpr.getUTerms();
        for (int i = 0; i < leftUTerms.size(); ++i) {
            UnitTerm uTerm = (UnitTerm)leftUTerms.elementAt(i);
            if (uTerm.isUnit()) {
                newRightUExpr.addUnitTerm(uTerm.invert());
                continue;
            }
            if (!uTerm.isVariable()) continue;
            newLeftUExpr.addUnitTerm(uTerm);
        }
        Vector rightUTerms = rhsUExpr.getUTerms();
        for (int i = 0; i < rightUTerms.size(); ++i) {
            UnitTerm uTerm = (UnitTerm)rightUTerms.elementAt(i);
            if (uTerm.isUnit()) {
                newRightUExpr.addUnitTerm(uTerm);
                continue;
            }
            if (!uTerm.isVariable()) continue;
            newLeftUExpr.addUnitTerm(uTerm.invert());
        }
        if (newRightUExpr.getUTerms().isEmpty()) {
            UnitTerm x = new UnitTerm();
            x.setUnit(UnitLibrary.Identity);
            newRightUExpr.addUnitTerm(x);
        }
        newRightUExpr = newRightUExpr.reduce();
        return new UnitEquation(newLeftUExpr, newRightUExpr);
    }

    public UnitEquation copy() {
        UnitEquation uE = new UnitEquation(this.getLhs().copy(), this.getRhs().copy());
        return uE;
    }

    public boolean isSatisfied() {
        UnitExpr lhsReduced = this.getLhs().reduce();
        UnitExpr rhsReduced = this.getRhs().reduce();
        Unit lhsUnit = lhsReduced.getSingleUnit();
        Unit rhsUnit = rhsReduced.getSingleUnit();
        if (lhsUnit == null || rhsUnit == null) {
            return false;
        }
        return lhsUnit.hasSameType(rhsUnit);
    }

    public Object visit(EquationVisitor visitor) throws IllegalActionException {
        return visitor._visitUnitEquation(this);
    }
}

