/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.unit;

import java.util.List;
import java.util.Vector;
import ptolemy.actor.IOPort;
import ptolemy.actor.IORelation;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.data.unit.Bindings;
import ptolemy.data.unit.ExpandPortNames;
import ptolemy.data.unit.Solution;
import ptolemy.data.unit.UnitAttribute;
import ptolemy.data.unit.UnitConstraint;
import ptolemy.data.unit.UnitEquation;
import ptolemy.data.unit.UnitExpr;
import ptolemy.data.unit.UnitPresentation;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;

public class UnitConstraints
implements UnitPresentation {
    private Bindings _bindings = null;
    private Vector _constraints = new Vector();
    private boolean _debug = false;
    private static ExpandPortNames _equationVisitor = new ExpandPortNames();
    private TypedCompositeActor _model = null;

    public UnitConstraints() {
    }

    public UnitConstraints(TypedCompositeActor model, Vector entities, Vector relations) throws IllegalActionException {
        this();
        UnitEquation uC;
        int i;
        this._model = model;
        this._bindings = new Bindings(entities);
        for (i = 0; i < entities.size(); ++i) {
            int j;
            ComponentEntity componentEntity = (ComponentEntity)entities.elementAt(i);
            Vector actorConstraints = new Vector();
            List unitsAttrs = componentEntity.attributeList(UnitAttribute.class);
            for (j = 0; j < unitsAttrs.size(); ++j) {
                UnitAttribute attr = (UnitAttribute)unitsAttrs.get(j);
                if (!attr.getName().equals("_unitConstraints")) continue;
                actorConstraints.addAll(attr.getUnitConstraints().getConstraints());
            }
            for (j = 0; j < actorConstraints.size(); ++j) {
                UnitEquation uEquation = ((UnitEquation)actorConstraints.elementAt(j)).copy();
                _equationVisitor.expand(uEquation, componentEntity);
                uEquation.setSource(componentEntity);
                this.addConstraint(uEquation);
            }
            for (IOPort actorPort : componentEntity.portList()) {
                UnitExpr rhsExpr = null;
                UnitAttribute ua = (UnitAttribute)actorPort.getAttribute("_units");
                if (ua != null) {
                    rhsExpr = ua.getUnitExpr();
                }
                if (rhsExpr == null) continue;
                UnitExpr lhsExpr = new UnitExpr(actorPort);
                uC = new UnitEquation(lhsExpr, rhsExpr);
                uC.setSource(actorPort);
                this.addConstraint(uC);
            }
        }
        for (i = 0; i < relations.size(); ++i) {
            IORelation relation = (IORelation)relations.elementAt(i);
            List ports = relation.linkedPortList();
            Port inputPort = null;
            for (IOPort port : ports) {
                if (!port.isOutput()) continue;
                inputPort = port;
            }
            if (inputPort == null || !this._bindings.bindingExists(inputPort.getName(inputPort.getContainer().getContainer()))) continue;
            for (IOPort outPort : ports) {
                if (outPort == inputPort || !this._bindings.bindingExists(outPort.getName(outPort.getContainer().getContainer()))) continue;
                UnitExpr lhsUExpr = new UnitExpr(outPort);
                UnitExpr rhsUExpr = new UnitExpr((IOPort)inputPort);
                uC = new UnitEquation(lhsUExpr, rhsUExpr);
                uC.setSource(relation);
                this.addConstraint(uC);
            }
        }
    }

    public void addConstraint(UnitConstraint constraint) {
        this._constraints.add(constraint);
    }

    public Solution completeSolution() throws IllegalActionException {
        Solution solution = null;
        if (this._debug) {
            System.out.println("Constraints\n" + this.descriptiveForm() + "\\Constraints");
        }
        Solution G = new Solution(this._model, this._bindings.variableLabels(), this.getConstraints());
        solution = G.completeSolution();
        return solution;
    }

    @Override
    public String descriptiveForm() {
        if (this._constraints == null) {
            return null;
        }
        StringBuffer retv = null;
        if (!this._constraints.isEmpty()) {
            retv = new StringBuffer(((UnitEquation)this._constraints.elementAt(0)).descriptiveForm());
        }
        for (int i = 1; i < this._constraints.size(); ++i) {
            retv.append(";" + ((UnitEquation)this._constraints.get(i)).descriptiveForm());
        }
        return retv.toString();
    }

    public Vector getConstraints() {
        return this._constraints;
    }

    public Vector minimalSpanSolutions() throws IllegalActionException {
        Vector solutions = null;
        if (this._debug) {
            System.out.println("Constraints\n" + this.descriptiveForm() + "\\Constraints");
        }
        Solution G = new Solution(this._model, this._bindings.variableLabels(), this.getConstraints());
        solutions = G.minimalSpanSolutions();
        if (this._debug) {
            System.out.println(G.headerInfo());
            for (int i = 0; i < solutions.size(); ++i) {
                System.out.println(((Solution)solutions.elementAt(i)).stateInfo());
            }
        }
        return solutions;
    }
}

