/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.type;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ptolemy.data.RecordToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.StructuredType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;

public class RecordType
extends StructuredType {
    private Map _fields = new HashMap();
    private static RecordType _representative = new RecordType(new String[0], new Type[0]);

    public RecordType(String[] labels, Type[] types) {
        if (labels.length != types.length) {
            throw new IllegalArgumentException("RecordType: the labels and types arrays do not have the same size.");
        }
        for (int i = 0; i < labels.length; ++i) {
            FieldType fieldType = new FieldType(types[i]);
            this._fields.put(labels[i], fieldType);
        }
    }

    public RecordType(Map fieldMap) throws IllegalActionException {
        for (Map.Entry entry : fieldMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalActionException("RecordType: given map contains either null keys or null values.");
            }
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof Type)) {
                throw new IllegalActionException("RecordType: given map contains either non-String keys or non-Type values.");
            }
            this._fields.put(entry.getKey(), new FieldType((Type)entry.getValue()));
        }
    }

    @Override
    public Object clone() {
        if (this.isConstant()) {
            return this;
        }
        Object[] labelsObj = this._fields.keySet().toArray();
        String[] labels = new String[labelsObj.length];
        Type[] types = new Type[labelsObj.length];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = (String)labelsObj[i];
            FieldType fieldType = (FieldType)this._fields.get(labels[i]);
            types[i] = fieldType._declaredType;
        }
        RecordType newObj = new RecordType(labels, types);
        try {
            newObj.updateType(this);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("RecordType.clone: Cannot update new instance. " + ex.getMessage());
        }
        return newObj;
    }

    @Override
    public Token convert(Token token) throws IllegalActionException {
        if (!this.isCompatible(token.getType())) {
            throw new IllegalArgumentException(Token.notSupportedConversionMessage(token, this.toString()));
        }
        RecordToken recordToken = (RecordToken)token;
        Object[] labelArray = this.labelSet().toArray();
        String[] labelStringArray = new String[labelArray.length];
        Token[] values = new Token[labelArray.length];
        for (int i = 0; i < labelArray.length; ++i) {
            String label = (String)labelArray[i];
            Token fieldToken = recordToken.get(label);
            Type newFieldType = this.get(label);
            values[i] = newFieldType.convert(fieldToken);
            labelStringArray[i] = label;
        }
        return new RecordToken(labelStringArray, values);
    }

    @Override
    public int depth() {
        Object[] labelsObj = this._fields.keySet().toArray();
        String[] labels = new String[labelsObj.length];
        int[] depth = new int[labelsObj.length];
        int maxDepth = 1;
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = (String)labelsObj[i];
            Type fieldType = this.get(labels[i]);
            depth[i] = 1;
            if (fieldType instanceof StructuredType) {
                int n = i;
                depth[n] = depth[n] + ((StructuredType)fieldType).depth();
            }
            if (depth[i] <= maxDepth) continue;
            maxDepth = depth[i];
        }
        return maxDepth;
    }

    @Override
    public boolean equals(Object object) {
        Set argLabelSet;
        if (!(object instanceof RecordType)) {
            return false;
        }
        RecordType recordType = (RecordType)object;
        Set myLabelSet = this._fields.keySet();
        if (!((Object)myLabelSet).equals(argLabelSet = recordType._fields.keySet())) {
            return false;
        }
        for (String label : myLabelSet) {
            Type argType;
            Type myType = this.get(label);
            if (((Object)myType).equals(argType = recordType.get(label))) continue;
            return false;
        }
        return true;
    }

    public Type get(String label) {
        FieldType fieldType = (FieldType)this._fields.get(label);
        if (fieldType == null) {
            return null;
        }
        return fieldType._resolvedType;
    }

    @Override
    public Class getTokenClass() {
        return RecordToken.class;
    }

    public InequalityTerm getTypeTerm(String label) {
        return (InequalityTerm)this._fields.get(label);
    }

    public int hashCode() {
        return ((Object)this._fields.keySet()).hashCode() + 2917;
    }

    @Override
    public boolean isAbstract() {
        for (String label : this._fields.keySet()) {
            Type type = this.get(label);
            if (!type.isAbstract()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initialize(Type type) {
        try {
            for (String label : this._fields.keySet()) {
                FieldType fieldType = (FieldType)this._fields.get(label);
                if (!fieldType.isSettable()) continue;
                fieldType.initialize(type);
            }
        }
        catch (IllegalActionException iae) {
            throw new InternalErrorException("RecordType.initialize: Cannot initialize the element type to " + type + " " + iae.getMessage());
        }
    }

    @Override
    public boolean isCompatible(Type type) {
        if (((Object)type).equals(BaseType.UNKNOWN)) {
            return true;
        }
        if (!(type instanceof RecordType)) {
            return false;
        }
        RecordType argumentRecordType = (RecordType)type;
        for (String label : this._fields.keySet()) {
            Type argumentFieldType = argumentRecordType.get(label);
            if (argumentFieldType == null) {
                return false;
            }
            Type thisFieldType = this.get(label);
            if (thisFieldType.isCompatible(argumentFieldType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isConstant() {
        for (FieldType fieldType : this._fields.values()) {
            Type type = fieldType._declaredType;
            if (type.isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInstantiable() {
        for (String label : this._fields.keySet()) {
            Type type = this.get(label);
            if (type.isInstantiable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubstitutionInstance(Type type) {
        Set argLabelSet;
        if (!(type instanceof RecordType)) {
            return false;
        }
        RecordType recordType = (RecordType)type;
        Set myLabelSet = this._fields.keySet();
        if (!((Object)myLabelSet).equals(argLabelSet = recordType._fields.keySet())) {
            return false;
        }
        for (String label : myLabelSet) {
            Type argType;
            FieldType fieldType = (FieldType)this._fields.get(label);
            Type myDeclaredType = fieldType._declaredType;
            if (myDeclaredType.isSubstitutionInstance(argType = recordType.get(label))) continue;
            return false;
        }
        return true;
    }

    public Set labelSet() {
        return this._fields.keySet();
    }

    @Override
    public String toString() {
        Object[] labelArray = this._fields.keySet().toArray();
        int size = labelArray.length;
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                String labeli = (String)labelArray[i];
                String labelj = (String)labelArray[j];
                if (labeli.compareTo(labelj) < 0) continue;
                Object temp = labelArray[i];
                labelArray[i] = labelArray[j];
                labelArray[j] = temp;
            }
        }
        StringBuffer results = new StringBuffer("{");
        for (int i = 0; i < size; ++i) {
            String label = (String)labelArray[i];
            String type = ((Object)this.get(label)).toString();
            if (i != 0) {
                results.append(", ");
            }
            results.append(label + " = " + type);
        }
        return results.toString() + "}";
    }

    @Override
    public void updateType(StructuredType newType) throws IllegalActionException {
        super.updateType(newType);
        if (this.isConstant()) {
            if (this.equals(newType)) {
                return;
            }
            throw new IllegalActionException("RecordType.updateType: This type is a constant and the argument is not the same as this type. This type: " + this.toString() + " argument: " + newType.toString());
        }
        if (!this.isSubstitutionInstance(newType)) {
            throw new IllegalActionException("RecordType.updateType: Cannot update this type to the new type.");
        }
        for (String label : this._fields.keySet()) {
            FieldType fieldType = (FieldType)this._fields.get(label);
            if (!fieldType.isSettable()) continue;
            Type newFieldType = ((RecordType)newType).get(label);
            fieldType.setValue(newFieldType);
        }
    }

    @Override
    protected int _compare(StructuredType type) {
        if (!(type instanceof RecordType)) {
            throw new IllegalArgumentException("RecordType._compare: The argument is not a RecordType.");
        }
        if (this.equals(type)) {
            return 0;
        }
        if (this._isLessThanOrEqualTo(this, (RecordType)type)) {
            return -1;
        }
        if (this._isLessThanOrEqualTo((RecordType)type, this)) {
            return 1;
        }
        return 2;
    }

    @Override
    protected StructuredType _getRepresentative() {
        return _representative;
    }

    @Override
    protected StructuredType _greatestLowerBound(StructuredType type) {
        if (!(type instanceof RecordType)) {
            throw new IllegalArgumentException("RecordType.greatestLowerBound: The argument is not a RecordType.");
        }
        RecordType recordType = (RecordType)type;
        HashSet unionSet = new HashSet();
        Set myLabelSet = this._fields.keySet();
        Set argLabelSet = recordType._fields.keySet();
        unionSet.addAll(myLabelSet);
        unionSet.addAll(argLabelSet);
        Object[] labelArray = unionSet.toArray();
        int size = labelArray.length;
        String[] labels = new String[size];
        Type[] types = new Type[size];
        for (int i = 0; i < size; ++i) {
            labels[i] = (String)labelArray[i];
            Type type1 = this.get(labels[i]);
            Type type2 = recordType.get(labels[i]);
            types[i] = type1 == null ? type2 : (type2 == null ? type1 : (Type)TypeLattice.lattice().greatestLowerBound(type1, type2));
        }
        return new RecordType(labels, types);
    }

    @Override
    protected StructuredType _leastUpperBound(StructuredType type) {
        if (!(type instanceof RecordType)) {
            throw new IllegalArgumentException("RecordType.leastUpperBound: The argument is not a RecordType.");
        }
        RecordType recordType = (RecordType)type;
        HashSet intersectionSet = new HashSet();
        Set myLabelSet = this._fields.keySet();
        Set argLabelSet = recordType._fields.keySet();
        intersectionSet.addAll(myLabelSet);
        intersectionSet.retainAll(argLabelSet);
        Object[] labelArray = intersectionSet.toArray();
        int size = labelArray.length;
        String[] labels = new String[size];
        Type[] types = new Type[size];
        for (int i = 0; i < size; ++i) {
            labels[i] = (String)labelArray[i];
            Type type1 = this.get(labels[i]);
            Type type2 = recordType.get(labels[i]);
            types[i] = (Type)TypeLattice.lattice().leastUpperBound(type1, type2);
        }
        return new RecordType(labels, types);
    }

    private boolean _isLessThanOrEqualTo(RecordType t1, RecordType t2) {
        Set labelSet2;
        Set labelSet1 = t1._fields.keySet();
        if (!labelSet1.containsAll(labelSet2 = t2._fields.keySet())) {
            return false;
        }
        for (String label : labelSet2) {
            Type type2;
            Type type1 = t1.get(label);
            int result = TypeLattice.compare(type1, type2 = t2.get(label));
            if (result != 1 && result != 2) continue;
            return false;
        }
        return true;
    }

    private class FieldType
    implements InequalityTerm {
        private Type _declaredType = null;
        private Type _resolvedType = null;

        private FieldType(Type declaredType) {
            try {
                this._resolvedType = this._declaredType = (Type)declaredType.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new InternalErrorException("RecordType.FieldType: The specified type cannot be cloned.");
            }
        }

        @Override
        public Object getAssociatedObject() {
            return RecordType.this;
        }

        @Override
        public Object getValue() {
            return this._resolvedType;
        }

        @Override
        public InequalityTerm[] getVariables() {
            if (this.isSettable()) {
                InequalityTerm[] variable = new InequalityTerm[]{this};
                return variable;
            }
            return new InequalityTerm[0];
        }

        @Override
        public void initialize(Object e) throws IllegalActionException {
            if (!this.isSettable()) {
                throw new IllegalActionException("RecordType$FieldType.initialize: The type is not settable.");
            }
            if (!(e instanceof Type)) {
                throw new IllegalActionException("FieldType.initialize: The argument is not a Type.");
            }
            if (this._declaredType == BaseType.UNKNOWN) {
                this._resolvedType = (Type)e;
            } else {
                ((StructuredType)this._resolvedType).initialize((Type)e);
            }
        }

        @Override
        public boolean isSettable() {
            return !this._declaredType.isConstant();
        }

        @Override
        public boolean isValueAcceptable() {
            return this._resolvedType.isInstantiable();
        }

        @Override
        public void setValue(Object e) throws IllegalActionException {
            if (!this.isSettable()) {
                throw new IllegalActionException("RecordType$FieldType.setValue: The type is not settable.");
            }
            if (!this._declaredType.isSubstitutionInstance((Type)e)) {
                throw new IllegalActionException("FieldType.setValue: Cannot update the field type of this RecordType to the new type. Field type: " + ((Object)this._declaredType).toString() + ", New type: " + e.toString());
            }
            if (this._declaredType == BaseType.UNKNOWN) {
                try {
                    this._resolvedType = (Type)((Type)e).clone();
                }
                catch (CloneNotSupportedException cnse) {
                    throw new InternalErrorException("RecordType$FieldType.setValue: The specified type cannot be cloned.");
                }
            } else {
                ((StructuredType)this._resolvedType).updateType((StructuredType)e);
            }
        }

        public String toString() {
            return "(RecordFieldType, " + this.getValue() + ")";
        }
    }
}

