/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import ptolemy.data.Token;
import ptolemy.data.expr.Node;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.ParseTreeVisitor;
import ptolemy.data.expr.PtParser;
import ptolemy.data.expr.PtParserTreeConstants;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.IllegalActionException;

public class ASTPtRootNode
implements Node,
Cloneable {
    protected Node _parent;
    protected ArrayList _children;
    protected int _id;
    protected Token _ptToken;
    protected Type _ptType;
    protected boolean _isConstant = false;

    public ASTPtRootNode(int i) {
        this._id = i;
    }

    public ASTPtRootNode(PtParser p, int i) {
        this(i);
    }

    public Object clone() throws CloneNotSupportedException {
        ASTPtRootNode node = (ASTPtRootNode)super.clone();
        if (this._children != null) {
            node._children = new ArrayList(this._children.size());
            for (ASTPtRootNode child : this._children) {
                ASTPtRootNode clone = (ASTPtRootNode)child.clone();
                node._children.add(clone);
                clone._parent = node;
            }
        }
        return node;
    }

    public void displayParseTree(String prefix) {
        if (this._ptToken != null) {
            String str = this.toString(prefix) + ", Token type: ";
            str = str + this._ptToken.getClass().getName() + ", Value: ";
            System.out.println(str + this._ptToken.toString());
        } else {
            System.out.println(this.toString(prefix) + "  _ptToken is null");
        }
        if (this._children != null) {
            for (int i = 0; i < this._children.size(); ++i) {
                ASTPtRootNode n = (ASTPtRootNode)this._children.get(i);
                if (n == null) continue;
                n.displayParseTree(prefix + " ");
            }
        }
    }

    public Token evaluateParseTree() throws IllegalActionException {
        ParseTreeEvaluator evaluator = new ParseTreeEvaluator();
        return evaluator.evaluateParseTree(this);
    }

    public Token getToken() {
        return this._ptToken;
    }

    public Type getType() {
        return this._ptType;
    }

    public boolean isCongruent(ASTPtRootNode node, Map renaming) {
        if (node._id != this._id) {
            return false;
        }
        if (node._children == null && this._children == null) {
            return true;
        }
        if (node._children == null || this._children == null) {
            return false;
        }
        if (node._children.size() != this._children.size()) {
            return false;
        }
        Iterator children = this._children.iterator();
        Iterator nodeChildren = node._children.iterator();
        while (children.hasNext()) {
            ASTPtRootNode nodeChild;
            ASTPtRootNode child = (ASTPtRootNode)children.next();
            if (child.isCongruent(nodeChild = (ASTPtRootNode)nodeChildren.next(), renaming)) continue;
            return false;
        }
        return true;
    }

    public boolean isConstant() {
        return this._isConstant;
    }

    public boolean isEvaluated() {
        return this._ptToken != null;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        if (i >= this._children.size()) {
            while (this._children.size() <= i) {
                this._children.add(null);
            }
        }
        this._children.set(i, n);
    }

    @Override
    public void jjtClose() {
        if (this._children != null) {
            this._children.trimToSize();
            this._isConstant = true;
            for (int i = 0; i < this._children.size(); ++i) {
                ASTPtRootNode ch = (ASTPtRootNode)this.jjtGetChild(i);
                if (ch._isConstant) continue;
                this._isConstant = false;
                break;
            }
        }
    }

    @Override
    public Node jjtGetChild(int i) {
        return (Node)this._children.get(i);
    }

    @Override
    public int jjtGetNumChildren() {
        return this._children == null ? 0 : this._children.size();
    }

    @Override
    public Node jjtGetParent() {
        return this._parent;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this._parent = n;
    }

    public void setConstant(boolean flag) {
        this._isConstant = flag;
    }

    public void setToken(Token token) {
        this._ptToken = token;
    }

    public void setType(Type type) {
        this._ptType = type;
    }

    public String toString() {
        return PtParserTreeConstants.jjtNodeName[this._id] + ":" + this._isConstant + ":" + this._ptType + ":" + this._ptToken;
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void visit(ParseTreeVisitor visitor) throws IllegalActionException {
        throw new IllegalActionException("The visit() method is not  implemented for nodes of type " + this.getClass().getName() + ".");
    }
}

