/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.BooleanToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.math.Complex;

public class UnsignedByteToken
extends ScalarToken {
    public static final UnsignedByteToken NIL = new UnsignedByteToken();
    public static final UnsignedByteToken ONE = new UnsignedByteToken(1);
    public static final UnsignedByteToken ZERO = new UnsignedByteToken(0);
    private byte _value;

    public UnsignedByteToken() {
        this._value = 0;
    }

    public UnsignedByteToken(byte value) {
        this._value = value;
    }

    public UnsignedByteToken(int value) {
        this._value = (byte)value;
    }

    public UnsignedByteToken(String init) throws IllegalActionException {
        if (init == null || init.equals("nil")) {
            throw new IllegalActionException(UnsignedByteToken.notSupportedNullNilStringMessage("UnsignedByteToken", init));
        }
        try {
            int value = Integer.parseInt(init);
            if (value > 255 || value < 0) {
                throw new IllegalActionException("Value '" + init + "' is out of the range of Unsigned Byte");
            }
            this._value = (byte)value;
        }
        catch (NumberFormatException e) {
            throw new IllegalActionException(null, e, "Failed to parse \"" + init + "\" as a number.");
        }
    }

    @Override
    public byte byteValue() {
        return this._value;
    }

    @Override
    public Complex complexValue() {
        return new Complex(UnsignedByteToken.unsignedConvert(this._value));
    }

    public static UnsignedByteToken convert(Token token) throws IllegalActionException {
        if (token instanceof UnsignedByteToken) {
            return (UnsignedByteToken)token;
        }
        if (token.isNil()) {
            return NIL;
        }
        int compare = TypeLattice.compare((Type)BaseType.UNSIGNED_BYTE, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(UnsignedByteToken.notSupportedIncomparableConversionMessage(token, "byte"));
        }
        throw new IllegalActionException(UnsignedByteToken.notSupportedConversionMessage(token, "byte"));
    }

    @Override
    public double doubleValue() {
        return UnsignedByteToken.unsignedConvert(this._value);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (this.isNil() || ((UnsignedByteToken)object).isNil()) {
            return false;
        }
        return ((UnsignedByteToken)object).byteValue() == this._value;
    }

    @Override
    public Type getType() {
        return BaseType.UNSIGNED_BYTE;
    }

    public int hashCode() {
        return this._value;
    }

    @Override
    public int intValue() {
        return UnsignedByteToken.unsignedConvert(this._value);
    }

    @Override
    public boolean isNil() {
        return this == NIL;
    }

    @Override
    public ScalarToken leftShift(int bits) {
        if (this.isNil()) {
            return NIL;
        }
        return new UnsignedByteToken(this._value << bits);
    }

    @Override
    public ScalarToken logicalRightShift(int bits) {
        if (this.isNil()) {
            return NIL;
        }
        return new UnsignedByteToken(this._value >>> bits);
    }

    @Override
    public long longValue() {
        return UnsignedByteToken.unsignedConvert(this._value);
    }

    @Override
    public Token one() {
        return ONE;
    }

    @Override
    public ScalarToken rightShift(int bits) {
        if (this.isNil()) {
            return NIL;
        }
        return new UnsignedByteToken(this._value >>> bits);
    }

    @Override
    public short shortValue() {
        return UnsignedByteToken.unsignedConvert(this._value);
    }

    @Override
    public String toString() {
        String unitString = "";
        if (!this._isUnitless()) {
            unitString = " * " + this.unitsString();
        }
        if (this.isNil()) {
            return super.toString();
        }
        return Integer.toString(UnsignedByteToken.unsignedConvert(this._value)) + "ub" + unitString;
    }

    public static short unsignedConvert(byte value) {
        short intValue = value;
        if (intValue < 0) {
            intValue = (short)(intValue + 256);
        }
        return intValue;
    }

    @Override
    public Token zero() {
        return ZERO;
    }

    @Override
    protected ScalarToken _absolute() {
        return this;
    }

    @Override
    protected ScalarToken _add(ScalarToken rightArgument) {
        byte sum = (byte)(this._value + ((UnsignedByteToken)rightArgument).byteValue());
        return new UnsignedByteToken(sum);
    }

    @Override
    protected ScalarToken _bitwiseAnd(ScalarToken rightArgument) {
        byte sum = (byte)(this._value & ((UnsignedByteToken)rightArgument).byteValue());
        return new UnsignedByteToken(sum);
    }

    @Override
    protected ScalarToken _bitwiseNot() {
        UnsignedByteToken result = new UnsignedByteToken(~this._value);
        return result;
    }

    @Override
    protected ScalarToken _bitwiseOr(ScalarToken rightArgument) {
        byte sum = (byte)(this._value | ((UnsignedByteToken)rightArgument).byteValue());
        return new UnsignedByteToken(sum);
    }

    @Override
    protected ScalarToken _bitwiseXor(ScalarToken rightArgument) {
        byte sum = (byte)(this._value ^ ((UnsignedByteToken)rightArgument).byteValue());
        return new UnsignedByteToken(sum);
    }

    @Override
    protected ScalarToken _divide(ScalarToken rightArgument) {
        byte quotient = (byte)(UnsignedByteToken.unsignedConvert(this._value) / UnsignedByteToken.unsignedConvert(((UnsignedByteToken)rightArgument).byteValue()));
        return new UnsignedByteToken(quotient);
    }

    @Override
    protected BooleanToken _isCloseTo(ScalarToken rightArgument, double epsilon) {
        long distance;
        long left;
        long right = ((UnsignedByteToken)rightArgument).longValue();
        if (right > (left = this.longValue()) + (distance = Math.round(Math.floor(epsilon))) || right < left - distance) {
            return BooleanToken.FALSE;
        }
        return BooleanToken.TRUE;
    }

    @Override
    protected BooleanToken _isLessThan(ScalarToken rightArgument) {
        UnsignedByteToken convertedArgument = (UnsignedByteToken)rightArgument;
        return BooleanToken.getInstance(UnsignedByteToken.unsignedConvert(this._value) < UnsignedByteToken.unsignedConvert(convertedArgument.byteValue()));
    }

    @Override
    protected ScalarToken _modulo(ScalarToken rightArgument) {
        byte remainder = (byte)(UnsignedByteToken.unsignedConvert(this._value) % UnsignedByteToken.unsignedConvert(((UnsignedByteToken)rightArgument).byteValue()));
        return new UnsignedByteToken(remainder);
    }

    @Override
    protected ScalarToken _multiply(ScalarToken rightArgument) {
        byte product = (byte)(UnsignedByteToken.unsignedConvert(this._value) * UnsignedByteToken.unsignedConvert(((UnsignedByteToken)rightArgument).byteValue()));
        return new UnsignedByteToken(product);
    }

    @Override
    protected ScalarToken _subtract(ScalarToken rightArgument) {
        byte difference = (byte)(UnsignedByteToken.unsignedConvert(this._value) - UnsignedByteToken.unsignedConvert(((UnsignedByteToken)rightArgument).byteValue()));
        return new UnsignedByteToken(difference);
    }
}

