/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.BooleanToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;

public class BooleanMatrixToken
extends MatrixToken {
    private boolean[][] _value = null;
    private int _rowCount = 0;
    private int _columnCount = 0;

    public BooleanMatrixToken() {
        this._rowCount = 1;
        this._columnCount = 1;
        this._value = new boolean[1][1];
        this._value[0][0] = false;
    }

    public BooleanMatrixToken(boolean[][] value) throws IllegalActionException {
        if (value == null) {
            throw new IllegalActionException("BooleanMatrixToken: The specified matrix is null.");
        }
        this._initialize(value);
    }

    public BooleanMatrixToken(String init) throws IllegalActionException {
        PtParser parser = new PtParser();
        ASTPtRootNode tree = parser.generateParseTree(init);
        Token token = new ParseTreeEvaluator().evaluateParseTree(tree);
        if (!(token instanceof BooleanMatrixToken)) {
            throw new IllegalActionException("A BooleanMatrixToken cannot be created from the expression '" + init + "'");
        }
        boolean[][] value = ((BooleanMatrixToken)token).booleanMatrix();
        this._initialize(value);
    }

    public BooleanMatrixToken(Token[] tokens, int rows, int columns) throws IllegalActionException {
        if (tokens == null) {
            throw new IllegalActionException("BooleanMatrixToken: The specified array is null.");
        }
        if (tokens.length != rows * columns) {
            throw new IllegalActionException("BooleanMatrixToken: The specified array is not of the correct length");
        }
        this._rowCount = rows;
        this._columnCount = columns;
        this._value = new boolean[rows][columns];
        for (int i = 0; i < tokens.length; ++i) {
            Token token = tokens[i];
            if (!(token instanceof BooleanToken)) {
                throw new IllegalActionException("BooleanMatrixToken: Element " + i + " in the array with value " + token + " is not a ScalarToken");
            }
            this._value[i / columns][i % columns] = ((BooleanToken)token).booleanValue();
        }
    }

    @Override
    public boolean[][] booleanMatrix() {
        boolean[][] result = new boolean[this._rowCount][this._columnCount];
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < this._columnCount; ++j) {
                result[i][j] = this._value[i][j];
            }
        }
        return result;
    }

    public static BooleanMatrixToken convert(Token token) throws IllegalActionException {
        if (token instanceof BooleanMatrixToken) {
            return (BooleanMatrixToken)token;
        }
        int compare = TypeLattice.compare((Type)BaseType.BOOLEAN_MATRIX, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(BooleanMatrixToken.notSupportedIncomparableConversionMessage(token, "[boolean]"));
        }
        throw new IllegalActionException(BooleanMatrixToken.notSupportedConversionMessage(token, "[boolean]"));
    }

    @Override
    public MatrixToken crop(int rowStart, int colStart, int rowSpan, int colSpan) throws IllegalActionException {
        boolean[][] value = this.booleanMatrix();
        try {
            boolean[][] result = new boolean[rowSpan][colSpan];
            for (int i = 0; i < rowSpan; ++i) {
                System.arraycopy(value[rowStart + i], colStart, result[i], 0, colSpan);
            }
            return new BooleanMatrixToken(result);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalActionException("Matrix crop indices out of bounds (rowStart = " + rowStart + ", colStart = " + colStart + ", rowSpan = " + rowSpan + ", colSpan = " + colSpan + ").");
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        BooleanMatrixToken matrixArgument = (BooleanMatrixToken)object;
        if (this._rowCount != matrixArgument.getRowCount()) {
            return false;
        }
        if (this._columnCount != matrixArgument.getColumnCount()) {
            return false;
        }
        boolean[][] matrix = matrixArgument.booleanMatrix();
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < this._columnCount; ++j) {
                if (this._value[i][j] == matrix[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getColumnCount() {
        return this._columnCount;
    }

    @Override
    public Token getElementAsToken(int row, int column) throws ArrayIndexOutOfBoundsException {
        return BooleanToken.getInstance(this._value[row][column]);
    }

    public boolean getElementAt(int row, int column) {
        return this._value[row][column];
    }

    @Override
    public Type getElementType() {
        return BaseType.INT;
    }

    @Override
    public int getRowCount() {
        return this._rowCount;
    }

    @Override
    public Type getType() {
        return BaseType.BOOLEAN_MATRIX;
    }

    public int hashCode() {
        int code = 0;
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < this._columnCount; ++j) {
                if (!this._value[i][j]) continue;
                ++code;
            }
        }
        return code;
    }

    @Override
    public MatrixToken join(MatrixToken[][] matrices) throws IllegalActionException {
        if (matrices == null || matrices.length == 0 || matrices[0].length == 0) {
            throw new IllegalActionException("matrixJoin: No input matrices.");
        }
        int rows = 0;
        int columns = 0;
        for (int i = 0; i < matrices.length; ++i) {
            rows += matrices[i][0].getRowCount();
        }
        for (int j = 0; j < matrices[0].length; ++j) {
            columns += matrices[0][j].getColumnCount();
        }
        boolean[][] tiled = new boolean[rows][columns];
        int row = 0;
        for (int i = 0; i < matrices.length; ++i) {
            int column = 0;
            for (int j = 0; j < matrices[i].length; ++j) {
                int columnCount;
                if (!(matrices[i][j] instanceof BooleanMatrixToken)) {
                    throw new IllegalActionException("matrixJoin: matrices not all of the same type.");
                }
                int rowCount = matrices[i][j].getRowCount();
                if (row + rowCount > rows) {
                    rowCount = rows - row;
                }
                if (column + (columnCount = matrices[i][j].getColumnCount()) > columns) {
                    columnCount = columns - column;
                }
                for (int ii = 0; ii < rowCount; ++ii) {
                    System.arraycopy(matrices[i][j].booleanMatrix()[ii], 0, tiled[row + ii], column, columnCount);
                }
                column += matrices[0][j].getColumnCount();
            }
            row += matrices[i][0].getRowCount();
        }
        return new BooleanMatrixToken(tiled);
    }

    @Override
    public MatrixToken[][] split(int[] rows, int[] columns) {
        MatrixToken[][] result = new MatrixToken[rows.length][columns.length];
        boolean[][] source = this.booleanMatrix();
        int row = 0;
        for (int i = 0; i < rows.length; ++i) {
            int column = 0;
            for (int j = 0; j < columns.length; ++j) {
                int columnspan;
                boolean[][] contents = new boolean[rows[i]][columns[j]];
                int rowspan = rows[i];
                if (row + rowspan > source.length) {
                    rowspan = source.length - row;
                }
                if (column + (columnspan = columns[j]) > source[0].length) {
                    columnspan = source[0].length - column;
                }
                if (columnspan > 0 && rowspan > 0) {
                    for (int ii = 0; ii < rowspan; ++ii) {
                        System.arraycopy(source[row + ii], column, contents[ii], 0, columnspan);
                    }
                }
                column += columns[j];
                try {
                    result[i][j] = new BooleanMatrixToken(contents);
                    continue;
                }
                catch (IllegalActionException e) {
                    throw new InternalErrorException(e);
                }
            }
            row += rows[i];
        }
        return result;
    }

    @Override
    public Token one() {
        try {
            return new BooleanMatrixToken(this._createIdentity(this._rowCount));
        }
        catch (IllegalActionException illegalAction) {
            throw new InternalErrorException("BooleanMatrixToken.one: Cannot create identity matrix.");
        }
    }

    @Override
    public Token oneRight() {
        try {
            return new BooleanMatrixToken(this._createIdentity(this._columnCount));
        }
        catch (IllegalActionException illegalAction) {
            throw new InternalErrorException("BooleanMatrixToken.oneRight: Cannot create identity matrix.");
        }
    }

    @Override
    public Token zero() {
        try {
            return new BooleanMatrixToken(new boolean[this._rowCount][this._columnCount]);
        }
        catch (IllegalActionException illegalAction) {
            throw new InternalErrorException("BooleanMatrixToken.zero: Cannot create zero matrix.");
        }
    }

    protected boolean[][] _createIdentity(int dim) {
        boolean[][] a = new boolean[dim][dim];
        for (int i = 0; i < dim; ++i) {
            a[i][i] = true;
        }
        return a;
    }

    private void _initialize(boolean[][] value) {
        this._rowCount = value.length;
        this._columnCount = value[0].length;
        this._value = new boolean[this._rowCount][this._columnCount];
        for (int i = 0; i < this._rowCount; ++i) {
            for (int j = 0; j < this._columnCount; ++j) {
                this._value[i][j] = value[i][j];
            }
        }
    }
}

