/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.util;

import ptolemy.actor.util.CQComparator;
import ptolemy.actor.util.Time;

public class TimedEvent {
    public Time timeStamp;
    public Object contents;

    public TimedEvent(Time time, Object obj) {
        this.timeStamp = time;
        this.contents = obj;
    }

    public String toString() {
        return "timeStamp: " + this.timeStamp + ", contents: " + this.contents;
    }

    public static class TimeComparator
    implements CQComparator {
        private double _binWidth = 1.0;
        private double _zeroReference = 0.0;

        public final int compare(Object object1, Object object2) {
            TimedEvent a = (TimedEvent)object1;
            TimedEvent b = (TimedEvent)object2;
            return a.timeStamp.compareTo(b.timeStamp);
        }

        @Override
        public long getVirtualBinNumber(Object entry) {
            long value = (long)((double)((TimedEvent)entry).timeStamp.subtract(this._zeroReference).getLongValue() / this._binWidth);
            if (value != Long.MAX_VALUE) {
                return value;
            }
            return 0x7FFFFFFFFFFFFFFEL;
        }

        @Override
        public void setBinWidth(Object[] entryArray) {
            if (entryArray == null) {
                this._binWidth = 1.0;
                this._zeroReference = 0.0;
                return;
            }
            double[] diff = new double[entryArray.length - 1];
            Time firstEntryTime = ((TimedEvent)entryArray[0]).timeStamp;
            Time lastEntryTime = ((TimedEvent)entryArray[entryArray.length - 1]).timeStamp;
            if (firstEntryTime.isInfinite() && firstEntryTime.equals(lastEntryTime)) {
                return;
            }
            double average = lastEntryTime.subtract(firstEntryTime).getDoubleValue();
            average /= (double)(entryArray.length - 1);
            double effAverage = 0.0;
            int nEffSamples = 0;
            for (int i = 1; i < entryArray.length; ++i) {
                if (!(diff[i - 1] < 2.0 * average)) continue;
                ++nEffSamples;
                effAverage += diff[i - 1];
            }
            if (effAverage == 0.0 || nEffSamples == 0) {
                return;
            }
            this._binWidth = (effAverage /= (double)nEffSamples) * 3.0;
        }

        @Override
        public void setZeroReference(Object zeroReference) {
            this._zeroReference = ((TimedEvent)zeroReference).timeStamp.getDoubleValue();
        }
    }
}

