/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import ptolemy.actor.Actor;
import ptolemy.actor.AtomicActor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.IOPort;
import ptolemy.actor.Receiver;
import ptolemy.actor.lib.Sink;
import ptolemy.actor.lib.Source;
import ptolemy.actor.util.FunctionDependency;
import ptolemy.graph.DirectedGraph;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;

public class FunctionDependencyOfCompositeActor
extends FunctionDependency {
    protected DirectedGraph _detailedDependencyGraph;
    private List _sinkActors;
    private List _sourceActors;
    private List _transformers;

    public FunctionDependencyOfCompositeActor(CompositeActor compositeActor) throws IllegalActionException, NameDuplicationException {
        super(compositeActor);
    }

    public Object[] getCycleNodes() {
        this._validate();
        return this._detailedDependencyGraph.cycleNodes();
    }

    public DirectedGraph getDetailedDependencyGraph() {
        this._validate();
        return this._detailedDependencyGraph;
    }

    @Override
    protected void _constructDependencyGraph() {
        this._constructDetailedDependencyGraph();
        Actor actor = (Actor)((Object)this.getContainer());
        Attribute attribute = this.getContainer().getAttribute("Atomic");
        if (attribute != null) {
            super._constructDependencyGraph();
        } else {
            this._dependencyGraph = this._constructDisconnectedDependencyGraph();
            ListIterator inputs = actor.inputPortList().listIterator();
            while (inputs.hasNext()) {
                IOPort inputPort = (IOPort)inputs.next();
                Collection reachableOutputs = this._detailedDependencyGraph.reachableNodes(this._detailedDependencyGraph.node(inputPort));
                ListIterator outputs = actor.outputPortList().listIterator();
                while (outputs.hasNext()) {
                    IOPort outputPort = (IOPort)outputs.next();
                    if (!reachableOutputs.contains(this._detailedDependencyGraph.node(outputPort))) continue;
                    this._dependencyGraph.addEdge(inputPort, outputPort);
                }
            }
        }
    }

    protected void _constructDetailedDependencyGraph() {
        CompositeActor actor = (CompositeActor)this.getContainer();
        this._detailedDependencyGraph = this._constructDisconnectedDependencyGraph();
        List embeddedActors = this._getEntities();
        this._sinkActors = new LinkedList();
        this._sourceActors = new LinkedList();
        this._transformers = new LinkedList();
        this._categorizeActors(embeddedActors);
        this._mergeActorsGraph(this._sourceActors);
        this._mergeActorsGraph(this._transformers);
        this._mergeActorsGraph(this._sinkActors);
        this._sinkActors = null;
        this._sourceActors = null;
        this._transformers = null;
        List outputPorts = actor.outputPortList();
        for (Actor embeddedActor : embeddedActors) {
            for (IOPort outPort : embeddedActor.outputPortList()) {
                Receiver[][] receivers = outPort.getRemoteReceivers();
                for (int i = 0; i < receivers.length; ++i) {
                    if (receivers[i] == null) continue;
                    for (int j = 0; j < receivers[i].length; ++j) {
                        IOPort ioPort = receivers[i][j].getContainer();
                        if (!embeddedActors.contains(ioPort.getContainer()) && !outputPorts.contains(ioPort)) continue;
                        this._detailedDependencyGraph.addEdge(outPort, ioPort);
                    }
                }
            }
        }
        ListIterator inputs = actor.inputPortList().listIterator();
        while (inputs.hasNext()) {
            IOPort inputPort = (IOPort)inputs.next();
            Receiver[][] receivers = inputPort.deepGetReceivers();
            for (int i = 0; i < receivers.length; ++i) {
                for (int j = 0; j < receivers[i].length; ++j) {
                    IOPort ioPort = receivers[i][j].getContainer();
                    Actor ioPortContainer = (Actor)((Object)ioPort.getContainer());
                    if (!embeddedActors.contains(ioPortContainer) && !actor.equals(ioPortContainer)) continue;
                    this._detailedDependencyGraph.addEdge(inputPort, ioPort);
                }
            }
        }
    }

    protected List _getEntities() {
        return ((CompositeActor)this.getContainer()).deepEntityList();
    }

    private void _categorizeActors(List actorList) {
        ListIterator actors = actorList.listIterator();
        while (actors.hasNext()) {
            Actor actor = (Actor)actors.next();
            if (actor instanceof AtomicActor) {
                if (actor instanceof Source) {
                    this._sourceActors.add(actor);
                    continue;
                }
                if (actor instanceof Sink) {
                    this._sinkActors.add(actor);
                    continue;
                }
                this._transformers.add(actor);
                continue;
            }
            int numberOfInputs = actor.inputPortList().size();
            int numberOfOutputs = actor.outputPortList().size();
            if (numberOfInputs == 0) {
                this._sourceActors.add(actor);
                continue;
            }
            if (numberOfOutputs == 0) {
                this._sinkActors.add(actor);
                continue;
            }
            this._transformers.add(actor);
        }
    }

    private void _mergeActorsGraph(List actorList) {
        for (Actor embeddedActor : actorList) {
            FunctionDependency functionDependency = embeddedActor.getFunctionDependency();
            if (functionDependency != null) {
                this._detailedDependencyGraph.addGraph(functionDependency.getDependencyGraph());
                continue;
            }
            throw new InternalErrorException("FunctionDependency can not be null. Check all four types of function dependencies. There must be something wrong.");
        }
    }
}

