/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.process;

import ptolemy.actor.IOPort;
import ptolemy.actor.Receiver;
import ptolemy.kernel.ComponentEntity;

public class BoundaryDetector {
    private Receiver _receiver;
    private boolean _insideBoundaryCacheIsOn = false;
    private boolean _isInsideBoundaryValue = false;
    private boolean _outsideBoundaryCacheIsOn = false;
    private boolean _isOutsideBoundaryValue = false;
    private boolean _connectedBoundaryCacheIsOn = false;
    private boolean _isConnectedBoundaryValue = false;
    private boolean _connectedInsideOfBoundaryCacheIsOn = false;
    private boolean _isConnectedInsideOfBoundaryValue = false;
    private boolean _connectedOutsideOfBoundaryCacheIsOn = false;
    private boolean _isConnectedOutsideOfBoundaryValue = false;

    public BoundaryDetector(Receiver receiver) {
        this._receiver = receiver;
    }

    public boolean isConnectedToBoundary() {
        if (this._connectedBoundaryCacheIsOn) {
            return this._isConnectedBoundaryValue;
        }
        IOPort contPort = this._receiver.getContainer();
        if (contPort == null) {
            this._connectedBoundaryCacheIsOn = false;
            this._isConnectedBoundaryValue = false;
            return this._isConnectedBoundaryValue;
        }
        ComponentEntity contEntity = (ComponentEntity)contPort.getContainer();
        IOPort connectedPort2 = null;
        ComponentEntity connectedEntity = null;
        for (IOPort connectedPort2 : contPort.connectedPortList()) {
            int j;
            int i;
            Receiver[][] receivers;
            connectedEntity = (ComponentEntity)connectedPort2.getContainer();
            if (connectedEntity == contEntity.getContainer() && connectedPort2.isInput() && connectedPort2.isOpaque()) {
                receivers = connectedPort2.deepGetReceivers();
                for (i = 0; i < receivers.length; ++i) {
                    for (j = 0; j < receivers[i].length; ++j) {
                        if (this._receiver != receivers[i][j]) continue;
                        this._connectedBoundaryCacheIsOn = true;
                        this._isConnectedBoundaryValue = true;
                        return true;
                    }
                }
                continue;
            }
            if (!connectedPort2.isOpaque() || connectedEntity.isAtomic() || !connectedPort2.isOutput()) continue;
            receivers = connectedPort2.getRemoteReceivers();
            for (i = 0; i < receivers.length; ++i) {
                for (j = 0; j < receivers[i].length; ++j) {
                    if (this._receiver != receivers[i][j]) continue;
                    this._connectedBoundaryCacheIsOn = true;
                    this._isConnectedBoundaryValue = true;
                    return true;
                }
            }
        }
        this._connectedBoundaryCacheIsOn = true;
        this._isConnectedBoundaryValue = false;
        return this._isConnectedBoundaryValue;
    }

    public boolean isConnectedToBoundaryInside() {
        if (this._connectedInsideOfBoundaryCacheIsOn) {
            return this._isConnectedInsideOfBoundaryValue;
        }
        IOPort contPort = this._receiver.getContainer();
        if (contPort == null) {
            this._connectedInsideOfBoundaryCacheIsOn = false;
            this._isConnectedInsideOfBoundaryValue = false;
            return this._isConnectedInsideOfBoundaryValue;
        }
        ComponentEntity contEntity = (ComponentEntity)contPort.getContainer();
        IOPort connectedPort2 = null;
        ComponentEntity connectedEntity = null;
        for (IOPort connectedPort2 : contPort.connectedPortList()) {
            connectedEntity = (ComponentEntity)connectedPort2.getContainer();
            if (connectedEntity != contEntity.getContainer() || !connectedPort2.isInput() || !connectedPort2.isOpaque()) continue;
            Receiver[][] receivers = connectedPort2.deepGetReceivers();
            for (int i = 0; i < receivers.length; ++i) {
                for (int j = 0; j < receivers[i].length; ++j) {
                    if (this._receiver != receivers[i][j]) continue;
                    this._connectedInsideOfBoundaryCacheIsOn = true;
                    this._isConnectedInsideOfBoundaryValue = true;
                    return true;
                }
            }
        }
        this._connectedInsideOfBoundaryCacheIsOn = true;
        this._isConnectedInsideOfBoundaryValue = false;
        return this._isConnectedInsideOfBoundaryValue;
    }

    public boolean isConnectedToBoundaryOutside() {
        if (this._connectedOutsideOfBoundaryCacheIsOn) {
            return this._isConnectedOutsideOfBoundaryValue;
        }
        IOPort contPort = this._receiver.getContainer();
        if (contPort == null) {
            this._connectedOutsideOfBoundaryCacheIsOn = false;
            this._isConnectedOutsideOfBoundaryValue = false;
            return this._isConnectedOutsideOfBoundaryValue;
        }
        for (IOPort connectedPort : contPort.connectedPortList()) {
            ComponentEntity connectedEntity = (ComponentEntity)connectedPort.getContainer();
            if (!connectedPort.isOpaque() || connectedEntity.isAtomic() || !connectedPort.isOutput()) continue;
            Receiver[][] receivers = connectedPort.getRemoteReceivers();
            for (int i = 0; i < receivers.length; ++i) {
                for (int j = 0; j < receivers[i].length; ++j) {
                    if (this._receiver != receivers[i][j]) continue;
                    this._connectedOutsideOfBoundaryCacheIsOn = true;
                    this._isConnectedOutsideOfBoundaryValue = true;
                    return true;
                }
            }
        }
        this._connectedOutsideOfBoundaryCacheIsOn = true;
        this._isConnectedOutsideOfBoundaryValue = false;
        return this._isConnectedOutsideOfBoundaryValue;
    }

    public boolean isInsideBoundary() {
        if (this._insideBoundaryCacheIsOn) {
            return this._isInsideBoundaryValue;
        }
        IOPort innerPort = this._receiver.getContainer();
        if (innerPort == null) {
            this._insideBoundaryCacheIsOn = false;
            this._isInsideBoundaryValue = false;
            return this._isInsideBoundaryValue;
        }
        ComponentEntity innerEntity = (ComponentEntity)innerPort.getContainer();
        if (innerEntity != null && !innerEntity.isAtomic() && innerPort.isOpaque()) {
            if (innerPort.isOutput() && !innerPort.isInput()) {
                this._isInsideBoundaryValue = true;
            } else if (!innerPort.isOutput() && innerPort.isInput()) {
                this._isInsideBoundaryValue = false;
            } else if (!innerPort.isOutput() && !innerPort.isInput()) {
                this._isInsideBoundaryValue = false;
            } else {
                throw new IllegalArgumentException("A port that is both an input and output can not be properly dealt with by PNQueueReceiver.isInsideBoundary");
            }
            this._insideBoundaryCacheIsOn = true;
            return this._isInsideBoundaryValue;
        }
        this._insideBoundaryCacheIsOn = true;
        this._isInsideBoundaryValue = false;
        return this._isInsideBoundaryValue;
    }

    public boolean isOutsideBoundary() {
        if (this._outsideBoundaryCacheIsOn) {
            return this._isInsideBoundaryValue;
        }
        IOPort innerPort = this._receiver.getContainer();
        if (innerPort == null) {
            this._outsideBoundaryCacheIsOn = false;
            this._isOutsideBoundaryValue = false;
            return this._isOutsideBoundaryValue;
        }
        ComponentEntity innerEntity = (ComponentEntity)innerPort.getContainer();
        if (innerEntity != null && !innerEntity.isAtomic() && innerPort.isOpaque()) {
            if (innerPort.isOutput() && !innerPort.isInput()) {
                this._isOutsideBoundaryValue = false;
            } else if (!innerPort.isOutput() && innerPort.isInput()) {
                this._isOutsideBoundaryValue = true;
            } else if (!innerPort.isOutput() && !innerPort.isInput()) {
                this._isOutsideBoundaryValue = false;
            } else {
                throw new IllegalArgumentException("A port that is both an input and output can not be properly dealt with by PNQueueReceiver.isInsideBoundary");
            }
            this._outsideBoundaryCacheIsOn = true;
            return this._isOutsideBoundaryValue;
        }
        this._outsideBoundaryCacheIsOn = true;
        this._isOutsideBoundaryValue = false;
        return this._isOutsideBoundaryValue;
    }

    public void reset() {
        this._insideBoundaryCacheIsOn = false;
        this._isInsideBoundaryValue = false;
        this._outsideBoundaryCacheIsOn = false;
        this._isOutsideBoundaryValue = false;
        this._connectedBoundaryCacheIsOn = false;
        this._isConnectedBoundaryValue = false;
    }
}

