/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.vhdl;

import java.math.BigInteger;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.vhdl.SynchronousFixTransformer;
import ptolemy.data.FixToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.math.FixPoint;
import ptolemy.math.FixPointQuantization;
import ptolemy.math.Overflow;
import ptolemy.math.Precision;
import ptolemy.math.Quantization;
import ptolemy.math.Rounding;

public class LogicFunction
extends SynchronousFixTransformer {
    public TypedIOPort A = new TypedIOPort(this, "A", true, false);
    public TypedIOPort B;
    public Parameter operation;

    public LogicFunction(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.A.setTypeEquals(BaseType.FIX);
        this.B = new TypedIOPort(this, "B", true, false);
        this.B.setTypeEquals(BaseType.FIX);
        this.operation = new StringParameter(this, "operation");
        this.operation.setExpression("AND");
        this.operation.addChoice("AND");
        this.operation.addChoice("OR");
        this.operation.addChoice("NAND");
        this.operation.addChoice("NOR");
        this.operation.addChoice("XOR");
        this.operation.addChoice("XNOR");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.A.isKnown() && this.B.isKnown()) {
            BigInteger intResult = null;
            Precision precision = new Precision(((Parameter)this.getAttribute("outputPrecision")).getExpression());
            if (this.A.hasToken(0) && this.B.hasToken(0)) {
                FixPoint valueA = ((FixToken)this.A.get(0)).fixValue();
                FixPoint valueB = ((FixToken)this.B.get(0)).fixValue();
                if (valueA.getPrecision().getNumberOfBits() != precision.getNumberOfBits()) {
                    throw new IllegalActionException((Nameable)this, "Input A has different width than the output port");
                }
                if (valueB.getPrecision().getNumberOfBits() != precision.getNumberOfBits()) {
                    throw new IllegalActionException((Nameable)this, "Input B has different width than the output port");
                }
                BigInteger bigIntA = valueA.getUnscaledValue();
                BigInteger bigIntB = valueB.getUnscaledValue();
                if (this.operation.getExpression().equals("AND")) {
                    intResult = bigIntA.and(bigIntB);
                } else if (this.operation.getExpression().equals("OR")) {
                    intResult = bigIntA.or(bigIntB);
                } else if (this.operation.getExpression().equals("NAND")) {
                    intResult = bigIntA.and(bigIntB).not();
                } else if (this.operation.getExpression().equals("NOR")) {
                    intResult = bigIntA.or(bigIntB).not();
                } else if (this.operation.getExpression().equals("XOR")) {
                    intResult = bigIntA.xor(bigIntB);
                } else if (this.operation.getExpression().equals("XNOR")) {
                    intResult = bigIntA.xor(bigIntB).not();
                }
            }
            if (intResult != null) {
                Overflow overflow = Overflow.getName(((Parameter)this.getAttribute("outputOverflow")).getExpression().toLowerCase());
                Rounding rounding = Rounding.getName(((Parameter)this.getAttribute("outputRounding")).getExpression().toLowerCase());
                FixPoint result = new FixPoint(intResult.doubleValue(), (Quantization)new FixPointQuantization(precision, overflow, rounding));
                this.sendOutput(this.output, 0, new FixToken(result));
            }
        } else {
            this.output.resend(0);
        }
    }

    @Override
    public void pruneDependencies() {
        super.pruneDependencies();
        this.removeDependency(this.A, this.output);
        this.removeDependency(this.B, this.output);
    }
}

