/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.string;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.BooleanToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class StringMatches
extends TypedAtomicActor {
    public PortParameter matchString;
    public TypedIOPort output;
    public PortParameter pattern = new PortParameter(this, "pattern");
    private Pattern _pattern;

    public StringMatches(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.pattern.setStringMode(true);
        this.pattern.setExpression("");
        new SingletonParameter(this.pattern.getPort(), "_showName").setToken(BooleanToken.TRUE);
        this.matchString = new PortParameter(this, "matchString");
        this.matchString.setStringMode(true);
        this.matchString.setExpression("");
        new SingletonParameter(this.matchString.getPort(), "_showName").setToken(BooleanToken.TRUE);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(BaseType.BOOLEAN);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.pattern) {
            try {
                String patternValue = ((StringToken)this.pattern.getToken()).stringValue();
                this._pattern = Pattern.compile(patternValue);
            }
            catch (PatternSyntaxException ex) {
                String patternValue = ((StringToken)this.pattern.getToken()).stringValue();
                throw new IllegalActionException((Nameable)this, ex, "Failed to compile regular expression \"" + patternValue + "\"");
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.pattern.update();
        this.matchString.update();
        String matchStringValue = ((StringToken)this.matchString.getToken()).stringValue();
        Matcher match = this._pattern.matcher(matchStringValue);
        this.output.send(0, new BooleanToken(match.find()));
    }
}

