/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.string;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class StringFunction
extends Transformer {
    public Parameter function;
    private int _function;
    private static final int _TRIM = 0;
    private static final int _TOUPPERCASE = 1;
    private static final int _TOLOWERCASE = 2;

    public StringFunction(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.STRING);
        this.output.setTypeEquals(BaseType.STRING);
        this.function = new Parameter(this, "function");
        this.function.setStringMode(true);
        this.function.setExpression("trim");
        this.function.addChoice("toLowerCase");
        this.function.addChoice("toUpperCase");
        this.function.addChoice("trim");
        this._function = 0;
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-15\" width=\"80\" height=\"30\" style=\"fill:white\"/>\n</svg>\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.function) {
            String functionName = ((StringToken)this.function.getToken()).stringValue();
            if (functionName.equals("trim")) {
                this._function = 0;
                return;
            } else if (functionName.equals("toUpperCase")) {
                this._function = 1;
                return;
            } else {
                if (!functionName.equals("toLowerCase")) throw new IllegalActionException((Nameable)this, "Unrecognized function: " + functionName);
                this._function = 2;
            }
            return;
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            StringToken inputToken = (StringToken)this.input.get(0);
            String value = inputToken.stringValue();
            this.output.send(0, new StringToken(this._doFunction(value)));
        }
    }

    private String _doFunction(String inputString) {
        switch (this._function) {
            case 0: {
                return inputString.trim();
            }
            case 1: {
                return inputString.toUpperCase();
            }
            case 2: {
                return inputString.toLowerCase();
            }
        }
        throw new InternalErrorException("Invalid value provided as function");
    }
}

