/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.security;

import java.io.ByteArrayOutputStream;
import java.security.Key;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.security.CipherActor;
import ptolemy.actor.lib.security.KeyToken;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Settable;

public class SymmetricDecryption
extends CipherActor {
    public TypedIOPort key;
    private Key _key = null;

    public SymmetricDecryption(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.algorithm.setVisibility(Settable.NOT_EDITABLE);
        this.algorithm.setPersistent(false);
        this.algorithm.setVisibility(Settable.EXPERT);
        this.key = new TypedIOPort(this, "key", true, false);
        this.key.setTypeEquals(KeyToken.KEY);
        this.keySize.setVisibility(Settable.EXPERT);
    }

    @Override
    public void fire() throws IllegalActionException {
        try {
            if (this.key.hasToken(0)) {
                KeyToken keyToken = (KeyToken)this.key.get(0);
                this._key = keyToken.getValue();
                if (!this._algorithm.equals(this._key.getAlgorithm())) {
                    this._algorithm = this._key.getAlgorithm();
                    this.algorithm.setExpression(this._algorithm);
                    this._updateCipherNeeded = true;
                    this._updateCipher();
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalActionException((Nameable)this, ex, "fire() failed");
        }
        super.fire();
    }

    @Override
    protected byte[] _process(byte[] dataBytes) throws IllegalActionException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this._cipher.init(2, this._key);
            byteArrayOutputStream.write(this._cipher.doFinal(dataBytes));
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception ex) {
            throw new IllegalActionException((Nameable)this, ex, "Problem processing " + dataBytes.length + " bytes.");
        }
    }
}

