/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.security;

import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.KeyGenerator;
import ptolemy.actor.lib.Source;
import ptolemy.actor.lib.security.KeyToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class SecretKey
extends Source {
    public StringParameter algorithm = new StringParameter(this, "algorithm");
    public StringParameter provider;
    public Parameter keySize;
    protected String _algorithm;
    protected int _keySize;
    protected String _provider;
    private javax.crypto.SecretKey _secretKey = null;
    private KeyToken _secretKeyToken;
    private boolean _updateSecretKeyNeeded = true;

    public SecretKey(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        Set<String> algorithms = Security.getAlgorithms("KeyGenerator");
        Iterator<String> algorithmsIterator = algorithms.iterator();
        int i = 0;
        while (algorithmsIterator.hasNext()) {
            String algorithmName = algorithmsIterator.next();
            this.algorithm.addChoice(algorithmName);
            ++i;
        }
        this.algorithm.setExpression("DES");
        this.output.setTypeEquals(KeyToken.KEY);
        this.provider = new StringParameter(this, "provider");
        this.provider.setExpression("SystemDefault");
        this.provider.addChoice("SystemDefault");
        Provider[] providers = Security.getProviders();
        for (int i2 = 0; i2 < providers.length; ++i2) {
            this.provider.addChoice(providers[i2].getName());
        }
        this.keySize = new Parameter((NamedObj)this, "keySize", new IntToken(56));
        this.keySize.setTypeEquals(BaseType.INT);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.algorithm) {
            this._updateSecretKeyNeeded = true;
            this._algorithm = ((StringToken)this.algorithm.getToken()).stringValue();
        } else if (attribute == this.provider) {
            this._updateSecretKeyNeeded = true;
            this._provider = ((StringToken)this.provider.getToken()).stringValue();
        } else if (attribute == this.keySize) {
            this._updateSecretKeyNeeded = true;
            this._keySize = ((IntToken)this.keySize.getToken()).intValue();
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this._updateSecretKey();
        this.output.send(0, this._secretKeyToken);
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._updateSecretKey();
    }

    private void _updateSecretKey() throws IllegalActionException {
        if (this._updateSecretKeyNeeded) {
            try {
                KeyGenerator keyGen = this._provider.equalsIgnoreCase("SystemDefault") ? KeyGenerator.getInstance(this._algorithm) : KeyGenerator.getInstance(this._algorithm, this._provider);
                keyGen.init(this._keySize, new SecureRandom());
                this._secretKey = keyGen.generateKey();
                this._secretKeyToken = new KeyToken(this._secretKey);
            }
            catch (Throwable throwable) {
                throw new IllegalActionException((Nameable)this, throwable, "Failed to initialize Key.");
            }
            this._updateSecretKeyNeeded = false;
        }
    }
}

