/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.UnsignedByteToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class DatagramWriter
extends TypedAtomicActor {
    public TypedIOPort triggerOutput;
    public Parameter localSocketNumber;
    public TypedIOPort data;
    public Parameter defaultRemoteAddress;
    public TypedIOPort remoteAddress = new TypedIOPort(this, "remoteAddress");
    public Parameter defaultRemoteSocketNumber;
    public TypedIOPort remoteSocketNumber;
    private InetAddress _address;
    private int _remoteSocketNumber;
    private DatagramSocket _socket;
    private int _localSocketNumber;

    public DatagramWriter(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.remoteAddress.setInput(true);
        this.remoteAddress.setMultiport(true);
        this.remoteAddress.setTypeEquals(BaseType.STRING);
        this.remoteSocketNumber = new TypedIOPort(this, "remoteSocketNumber");
        this.remoteSocketNumber.setInput(true);
        this.remoteSocketNumber.setMultiport(true);
        this.remoteSocketNumber.setTypeEquals(BaseType.INT);
        this.data = new TypedIOPort(this, "data");
        this.data.setInput(true);
        this.data.setTypeEquals(new ArrayType(BaseType.UNSIGNED_BYTE));
        this.defaultRemoteAddress = new Parameter(this, "defaultRemoteAddress");
        this.defaultRemoteAddress.setTypeEquals(BaseType.STRING);
        this.defaultRemoteAddress.setToken(new StringToken("localhost"));
        this.defaultRemoteSocketNumber = new Parameter(this, "defaultRemoteSocketNumber");
        this.defaultRemoteSocketNumber.setTypeEquals(BaseType.INT);
        this.defaultRemoteSocketNumber.setExpression("4004");
        this.localSocketNumber = new Parameter(this, "localSocketNumber");
        this.localSocketNumber.setTypeEquals(BaseType.INT);
        this.localSocketNumber.setToken(new IntToken(4003));
        this.triggerOutput = new TypedIOPort(this, "triggerOutput");
        this.triggerOutput.setTypeEquals(BaseType.GENERAL);
        this.triggerOutput.setOutput(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.localSocketNumber) {
            DatagramWriter datagramWriter = this;
            synchronized (datagramWriter) {
                if (this._socket != null) {
                    if (this._debugging) {
                        this._debug("Current socket port is " + this._socket.getLocalPort());
                    }
                    this._localSocketNumber = ((IntToken)this.localSocketNumber.getToken()).intValue();
                    if (this._debugging) {
                        this._debug("Socket number is " + this._localSocketNumber);
                    }
                    try {
                        if (this._debugging) {
                            this._debug("Try create socket for port " + this._localSocketNumber);
                        }
                        DatagramSocket newSocket = new DatagramSocket(this._localSocketNumber);
                        if (this._debugging) {
                            this._debug("A socket is created!!");
                        }
                        this._socket.close();
                        this._socket = newSocket;
                    }
                    catch (SocketException ex) {
                        throw new IllegalActionException((Nameable)this, ex, "Cannot create socket on the given local socket number.");
                    }
                }
            }
        }
        if (attribute == this.defaultRemoteAddress) {
            String address = ((StringToken)this.defaultRemoteAddress.getToken()).stringValue();
            try {
                this._address = InetAddress.getByName(address);
            }
            catch (UnknownHostException ex) {
                throw new IllegalActionException((Nameable)this, ex, "The default remote address specifies an unknown host");
            }
        } else if (attribute == this.defaultRemoteSocketNumber) {
            this._remoteSocketNumber = ((IntToken)this.defaultRemoteSocketNumber.getToken()).intValue();
            this._remoteSocketNumber &= 0xFFFF;
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        int jj;
        super.fire();
        String address = null;
        for (jj = 0; jj < this.remoteAddress.getWidth(); ++jj) {
            if (!this.remoteAddress.hasToken(jj)) continue;
            address = ((StringToken)this.remoteAddress.get(jj)).stringValue();
        }
        if (address != null) {
            try {
                this._address = InetAddress.getByName(address);
            }
            catch (UnknownHostException ex) {
                throw new IllegalActionException((Nameable)this, ex, "The input remote address specifies an unknown host");
            }
        }
        for (jj = 0; jj < this.remoteSocketNumber.getWidth(); ++jj) {
            if (!this.remoteSocketNumber.hasToken(jj)) continue;
            this._remoteSocketNumber = 0xFFFF & ((IntToken)this.remoteSocketNumber.get(jj)).intValue();
        }
        if (this.data.hasToken(0)) {
            ArrayToken dataArrayToken = (ArrayToken)this.data.get(0);
            byte[] dataBytes = new byte[dataArrayToken.length()];
            for (int j = 0; j < dataArrayToken.length(); ++j) {
                UnsignedByteToken token = (UnsignedByteToken)dataArrayToken.getElement(j);
                dataBytes[j] = token.byteValue();
            }
            DatagramPacket packet = new DatagramPacket(dataBytes, dataBytes.length, this._address, this._remoteSocketNumber);
            try {
                this._socket.send(packet);
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.triggerOutput.broadcast(new Token());
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._localSocketNumber = ((IntToken)this.localSocketNumber.getToken()).intValue();
        if (this._localSocketNumber < 0 || this._localSocketNumber > 65535) {
            throw new IllegalActionException((Nameable)this, "Local socket number " + this._localSocketNumber + " must be between 0 and 65535.");
        }
        try {
            if (this._debugging) {
                this._debug("PI Try create socket number " + this._localSocketNumber);
            }
            this._socket = new DatagramSocket(this._localSocketNumber);
            if (this._debugging) {
                this._debug("PI A socket is created!!");
            }
        }
        catch (SocketException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Cannot create socket on the specified local socket number");
        }
        String address = ((StringToken)this.defaultRemoteAddress.getToken()).stringValue();
        try {
            this._address = InetAddress.getByName(address);
        }
        catch (UnknownHostException ex) {
            throw new IllegalActionException((Nameable)this, ex, "The default remote address specifies an unknown host");
        }
        this._remoteSocketNumber = ((IntToken)this.defaultRemoteSocketNumber.getToken()).intValue();
        if (this._remoteSocketNumber < 0 || this._remoteSocketNumber > 65535) {
            this._remoteSocketNumber &= 0xFFFF;
            throw new IllegalActionException((Nameable)this, "defaultRemoteSocketNumber" + this._remoteSocketNumber + " is out of range, must be between 0 and 65535.");
        }
    }

    @Override
    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        if (container != this.getContainer()) {
            this.wrapup();
        }
        super.setContainer(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wrapup() throws IllegalActionException {
        DatagramWriter datagramWriter = this;
        synchronized (datagramWriter) {
            if (this._socket != null) {
                this._socket.close();
                this._socket = null;
            }
        }
    }
}

