/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.jni;

import java.util.List;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.actor.lib.jni.CompiledCompositeActor;
import ptolemy.domains.sdf.kernel.SDFDirector;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;

public class EmbeddedCActor
extends CompiledCompositeActor {
    public StringAttribute embeddedCCode = new StringAttribute(this, "embeddedCCode");
    private EmbeddedActor _embeddedActor = null;

    public EmbeddedCActor(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.embeddedCCode.setVisibility(Settable.EXPERT);
        String code = "";
        code = code + this._getFileDependencies();
        code = code + this._getPreinitBlock();
        code = code + this._getInitBlock();
        code = code + this._getFireBlock();
        code = code + this._getWrapupBlock();
        this.embeddedCCode.setExpression(code);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-15\" width=\"62\" height=\"30\" style=\"fill:black\"/>\n<text x=\"-29\" y=\"4\"style=\"font-size:10; fill:white; font-family:SansSerif\">EmbeddedC</text>\n</svg>\n");
        this.invokeJNI.setExpression("true");
        new SDFDirector(this, "SDFDirector");
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        try {
            this._embeddedActor = new EmbeddedActor(this, "EmbeddedActor");
            int i = 0;
            for (TypedIOPort port : this.portList()) {
                TypedIOPort newPort = (TypedIOPort)port.clone(this.workspace());
                newPort.setContainer(this._embeddedActor);
                for (int channel = 0; channel < port.getWidth(); ++channel) {
                    TypedIORelation relation = new TypedIORelation(this, "relation" + i++);
                    port.link(relation);
                    newPort.link(relation);
                }
            }
        }
        catch (NameDuplicationException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Name duplication.");
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Clone not supported.");
        }
        super.preinitialize();
    }

    @Override
    public void wrapup() throws IllegalActionException {
        try {
            for (TypedIOPort port : this.portList()) {
                List insideRelationList = port.insideRelationList();
                for (TypedIORelation relation : insideRelationList) {
                    relation.setContainer(null);
                }
            }
            if (this._embeddedActor != null) {
                this._embeddedActor.setContainer(null);
            }
        }
        catch (NameDuplicationException ex) {
            throw new IllegalActionException((Nameable)this, "name duplication.");
        }
        super.wrapup();
    }

    protected String _getFileDependencies() {
        String code = "/***fileDependencies***/\n/**/\n\n";
        return code;
    }

    protected String _getFireBlock() {
        String code = "/***fireBlock***/\n// Assuming you have added an input port named \"input\"\n// and an output port named \"output\", then the following\n// line results in the input being copied to the output.\n//$ref(output) = $ref(input);\n/**/\n\n";
        return code;
    }

    protected String _getInitBlock() {
        String code = "/***initBlock***/\n/**/\n\n";
        return code;
    }

    protected String _getPreinitBlock() {
        String code = "/***preinitBlock***/\n/**/\n\n";
        return code;
    }

    protected String _getWrapupBlock() {
        String code = "/***wrapupBlock***/\n/**/\n\n";
        return code;
    }

    public static class EmbeddedActor
    extends TypedAtomicActor {
        public EmbeddedActor(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
            this.setPersistent(false);
        }
    }
}

