/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.javasound;

import java.io.IOException;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.data.IntToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.media.javasound.LiveSound;
import ptolemy.moml.SharedParameter;

public class LiveSoundActor
extends TypedAtomicActor {
    public SharedParameter bitsPerSample;
    public SharedParameter bufferSize;
    public SharedParameter channels;
    public SharedParameter sampleRate = new SharedParameter((NamedObj)this, "sampleRate", LiveSoundActor.class);
    public SharedParameter transferSize;
    protected int _bitsPerSample;
    protected int _bufferSize;
    protected int _channels;
    protected int _sampleRate;
    protected int _transferSize;
    protected boolean _isExecuting = false;

    public LiveSoundActor(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.sampleRate.setExpression("8000");
        this.sampleRate.setTypeEquals(BaseType.INT);
        this.bitsPerSample = new SharedParameter((NamedObj)this, "bitsPerSample", LiveSoundActor.class);
        this.bitsPerSample.setExpression("16");
        this.bitsPerSample.setTypeEquals(BaseType.INT);
        this.channels = new SharedParameter((NamedObj)this, "channels", LiveSoundActor.class);
        this.channels.setExpression("1");
        this.channels.setTypeEquals(BaseType.INT);
        this.transferSize = new SharedParameter((NamedObj)this, "transferSize", LiveSoundActor.class);
        this.transferSize.setExpression("128");
        this.transferSize.setTypeEquals(BaseType.INT);
        this.bufferSize = new SharedParameter((NamedObj)this, "bufferSize", LiveSoundActor.class);
        this.bufferSize.setExpression("1024");
        this.bufferSize.setTypeEquals(BaseType.INT);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        try {
            if (attribute == this.transferSize) {
                this._transferSize = ((IntToken)this.transferSize.getToken()).intValue();
                if (!this._isExecuting && LiveSound.getTransferSize() != this._transferSize) {
                    LiveSound.setTransferSize(this._transferSize);
                }
            } else if (attribute == this.bufferSize) {
                this._bufferSize = ((IntToken)this.bufferSize.getToken()).intValue();
                if (!this._isExecuting && LiveSound.getBufferSize() != this._bufferSize) {
                    LiveSound.setBufferSize(this._bufferSize);
                }
            } else if (attribute == this.channels) {
                this._channels = ((IntToken)this.channels.getToken()).intValue();
                if (this._channels < 1) {
                    throw new IllegalActionException((Nameable)this, "Attempt to set channels parameter to an illegal value of: " + this._channels + " . The value must be a " + "positive integer.");
                }
                if (!this._isExecuting && LiveSound.getChannels() != this._channels) {
                    LiveSound.setChannels(this._channels);
                }
            } else if (attribute == this.sampleRate) {
                this._sampleRate = ((IntToken)this.sampleRate.getToken()).intValue();
                if (!this._isExecuting && LiveSound.getSampleRate() != this._sampleRate) {
                    LiveSound.setSampleRate(this._sampleRate);
                }
            } else if (attribute == this.bitsPerSample) {
                this._bitsPerSample = ((IntToken)this.bitsPerSample.getToken()).intValue();
                if (!this._isExecuting && LiveSound.getBitsPerSample() != this._bitsPerSample) {
                    LiveSound.setBitsPerSample(this._bitsPerSample);
                }
            }
            super.attributeChanged(attribute);
            return;
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Cannot perform audio playback with the specified parameter values.");
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._isExecuting = true;
    }

    @Override
    public void wrapup() throws IllegalActionException {
        super.wrapup();
        this._isExecuting = false;
    }

    protected synchronized void _initializeAudio() throws IllegalActionException, IOException {
        if (LiveSound.getSampleRate() != this._sampleRate) {
            LiveSound.setSampleRate(this._sampleRate);
        }
        if (LiveSound.getBitsPerSample() != this._bitsPerSample) {
            LiveSound.setBitsPerSample(this._bitsPerSample);
        }
        if (LiveSound.getChannels() != this._channels) {
            LiveSound.setChannels(this._channels);
        }
        if (LiveSound.getBufferSize() != this._bufferSize) {
            LiveSound.setBufferSize(this._bufferSize);
        }
        if (LiveSound.getTransferSize() != this._transferSize) {
            LiveSound.setTransferSize(this._transferSize);
        }
    }
}

