/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.javasound;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.BooleanToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.util.ClassUtilities;

public class ClipPlayer
extends TypedAtomicActor
implements LineListener {
    public FileParameter fileOrURL;
    public TypedIOPort output;
    public Parameter overlay;
    public TypedIOPort trigger;
    protected List<Clip> _clips = new LinkedList<Clip>();
    private List<BooleanToken> _outputEvents = new LinkedList<BooleanToken>();
    private List<BooleanToken> _outputEventsCopy = null;

    public ClipPlayer(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.trigger = new TypedIOPort(this, "trigger", true, false);
        this.fileOrURL = new FileParameter(this, "fileOrURL");
        this.fileOrURL.setExpression("$PTII/ptolemy/actor/lib/javasound/voice.wav");
        this.overlay = new Parameter(this, "overlay");
        this.overlay.setTypeEquals(BaseType.BOOLEAN);
        this.overlay.setExpression("false");
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(BaseType.BOOLEAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this._outputEventsCopy == null) {
            List<BooleanToken> list = this._outputEvents;
            synchronized (list) {
                this._outputEventsCopy = new LinkedList<BooleanToken>(this._outputEvents);
                this._outputEvents.clear();
            }
        }
        for (BooleanToken token : this._outputEventsCopy) {
            this.output.send(0, token);
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this._outputEventsCopy = null;
        if (this.trigger.hasToken(0)) {
            this.trigger.get(0);
            boolean overlayValue = ((BooleanToken)this.overlay.getToken()).booleanValue();
            if (overlayValue || this._clips.size() == 0) {
                for (Clip clip : this._clips) {
                    if (clip.isActive()) continue;
                    clip.setFramePosition(0);
                    clip.start();
                    return true;
                }
                try {
                    Clip clip = AudioSystem.getClip();
                    clip.addLineListener(this);
                    AudioInputStream stream = null;
                    try {
                        stream = AudioSystem.getAudioInputStream(this.fileOrURL.asURL());
                    }
                    catch (IOException ex) {
                        try {
                            URL possibleJarURL = ClassUtilities.jarURLEntryResource(this.fileOrURL.getExpression());
                            stream = AudioSystem.getAudioInputStream(possibleJarURL);
                        }
                        catch (Exception ex2) {
                            IOException ioException = new IOException("Failed to open \"" + this.fileOrURL.getExpression() + "\".");
                            ioException.initCause(ex);
                            throw ioException;
                        }
                    }
                    clip.open(stream);
                    clip.start();
                    this._clips.add(clip);
                }
                catch (Exception e) {
                    throw new IllegalActionException((Nameable)this, e, "Error opening audio file or URL: " + this.fileOrURL.getExpression());
                }
            }
            Clip clip = this._clips.get(this._clips.size() - 1);
            if (clip.isActive()) {
                clip.stop();
            }
            clip.setFramePosition(0);
            clip.start();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(LineEvent event) {
        List<BooleanToken> list;
        if (event.getType().equals(LineEvent.Type.STOP)) {
            list = this._outputEvents;
            synchronized (list) {
                this._outputEvents.add(BooleanToken.FALSE);
            }
        }
        if (event.getType().equals(LineEvent.Type.START)) {
            list = this._outputEvents;
            synchronized (list) {
                this._outputEvents.add(BooleanToken.TRUE);
            }
        }
        try {
            this.getDirector().fireAtCurrentTime(this);
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public void wrapup() throws IllegalActionException {
        super.wrapup();
        for (Clip clip : this._clips) {
            clip.flush();
            clip.stop();
            clip.close();
        }
        this._clips.clear();
    }
}

