/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.image;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.util.List;
import javax.swing.JFrame;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.actor.gui.TokenEffigy;
import ptolemy.actor.gui.TokenTableau;
import ptolemy.data.ImageToken;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.media.Picture;

public class ImageTableau
extends TokenTableau {
    private int _oldxsize = 0;
    private int _oldysize = 0;
    private Picture _picture;

    public ImageTableau(Effigy container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public ImageTableau(Effigy container, String name, TableauFrame frame) throws IllegalActionException, NameDuplicationException {
        super(container, name, frame);
    }

    public ImageTableau(Effigy container, String name, TableauFrame frame, int width, int height) throws IllegalActionException, NameDuplicationException {
        super(container, name, frame);
        this._oldxsize = width;
        this._oldysize = height;
    }

    @Override
    public void append(Token token) throws IllegalActionException {
        if (token instanceof ImageToken) {
            this.display((ImageToken)token);
        }
    }

    @Override
    public void append(List list) throws IllegalActionException {
        for (Object token : list) {
            if (!(token instanceof ImageToken)) continue;
            this.display((ImageToken)token);
        }
    }

    public static boolean canDisplay(Token token) {
        return token instanceof ImageToken;
    }

    @Override
    public void clear() {
        if (this._picture != null) {
            // empty if block
        }
    }

    @Override
    public void createFrame(TableauFrame frame) throws IllegalActionException {
        TokenEffigy effigy = (TokenEffigy)this.getContainer();
        if (frame == null) {
            frame = new TableauFrame(this, null);
        }
        this.setFrame(frame);
        this._picture = new Picture(this._oldxsize, this._oldysize);
        frame.getContentPane().add((Component)this._picture, "Center");
        for (Object token : effigy.getTokens()) {
            this.display((ImageToken)token);
        }
    }

    public void display(ImageToken token) throws IllegalActionException {
        Image image = token.asAWTImage();
        if (image == null) {
            throw new IllegalActionException((Nameable)this, "ImageTableau: input image was null!");
        }
        int xsize = image.getWidth(null);
        int ysize = image.getHeight(null);
        if (this._oldxsize != xsize || this._oldysize != ysize) {
            if (this._debugging) {
                this._debug("Image size has changed.");
            }
            this._oldxsize = xsize;
            this._oldysize = ysize;
            Container container = this._picture.getParent();
            Container top = container.getParent();
            while (top.getParent() != null) {
                top = top.getParent();
            }
            JFrame castTop = (JFrame)top;
            castTop.getContentPane().remove(this._picture);
            this._picture = new Picture(xsize, ysize);
            this._picture.setImage(image);
            this._picture.setBackground(null);
            castTop.getContentPane().add((Component)this._picture, "Center");
            castTop.getContentPane().validate();
            castTop.pack();
        } else {
            this._picture.setImage(image);
        }
        this._picture.displayImage();
        this._picture.repaint();
        Thread.yield();
    }

    public static class Factory
    extends TableauFactory {
        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        @Override
        public Tableau createTableau(Effigy effigy) throws Exception {
            if (effigy instanceof TokenEffigy) {
                TokenTableau tableau = (TokenTableau)effigy.getEntity("tokenTableau");
                if (tableau != null) {
                    return tableau;
                }
                return new TokenTableau(effigy, "tokenTableau");
            }
            return null;
        }
    }
}

