/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.hoc;

import java.util.Iterator;
import java.util.List;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.MoMLChangeRequest;

public class MultiInstanceComposite
extends TypedCompositeActor {
    public Parameter nInstances;
    public Parameter instance;
    private boolean _isMasterCopy = false;

    public MultiInstanceComposite(Workspace workspace) {
        super(workspace);
        this._initialize();
    }

    public MultiInstanceComposite(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._initialize();
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        MultiInstanceComposite newObject = (MultiInstanceComposite)super.clone(workspace);
        newObject._isMasterCopy = this._isMasterCopy;
        return newObject;
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        if (!this._isMasterCopy) {
            return;
        }
        if (this.getDirector() == null || this.getDirector().getContainer() != this) {
            throw new IllegalActionException((Nameable)this, this.getFullName() + "No director.");
        }
        int N = ((IntToken)this.nInstances.getToken()).intValue();
        this.instance.setToken(new IntToken(0));
        TypedCompositeActor container = (TypedCompositeActor)this.getContainer();
        for (int i = 1; i < N; ++i) {
            MultiInstanceComposite clone = (MultiInstanceComposite)container.getEntity(this.getName() + "_" + i);
            if (clone != null) continue;
            try {
                clone = (MultiInstanceComposite)this._cloneClone(container.workspace());
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalActionException((Nameable)this, ex, "Clone failed.");
            }
            try {
                clone.setName(this.getName() + "_" + i);
                clone.setContainer(container);
                clone.validateSettables();
                if (this._debugging) {
                    this._debug("Cloned: " + clone.getFullName());
                }
                for (TypedIOPort port : this.portList()) {
                    TypedIORelation relation;
                    TypedIOPort newPort = (TypedIOPort)clone.getPort(port.getName());
                    List relations = port.linkedRelationList();
                    if (relations == null || relations.size() < 1) continue;
                    if (relations.size() > 1) {
                        throw new IllegalActionException((Nameable)port, "Can be linked to one relation only");
                    }
                    TypedIORelation oldRelation = relation = (TypedIORelation)relations.get(0);
                    Iterator otherPorts = relation.linkedPortList(port).iterator();
                    boolean isRelationCreated = false;
                    boolean isPortLinked = false;
                    while (otherPorts.hasNext()) {
                        TypedIOPort otherPort = (TypedIOPort)otherPorts.next();
                        if (port.isOutput() && !otherPort.isMultiport()) {
                            throw new IllegalActionException((Nameable)this, this.getFullName() + ".preinitialize(): " + "output port " + port.getName() + "must be connected to a multi-port");
                        }
                        boolean isInsideLinked = otherPort.isInsideGroupLinked(oldRelation);
                        if (!(port.isInput() && (!isInsideLinked && otherPort.isOutput() || isInsideLinked && otherPort.isInput())) && (!port.isOutput() || (isInsideLinked || !otherPort.isInput()) && (!isInsideLinked || !otherPort.isOutput()))) continue;
                        if (otherPort.isMultiport()) {
                            if (!isRelationCreated) {
                                relation = new TypedIORelation(container, "r_" + this.getName() + "_" + i + "_" + port.getName());
                                relation.setPersistent(false);
                                isRelationCreated = true;
                                if (this._debugging) {
                                    this._debug(port.getFullName() + ": created relation " + relation.getFullName());
                                }
                            }
                            otherPort.link(relation);
                        }
                        if (isPortLinked) continue;
                        newPort.link(relation);
                        isPortLinked = true;
                        if (!this._debugging) continue;
                        this._debug(newPort.getFullName() + ": linked to " + relation.getFullName());
                    }
                }
                clone.instance.setToken(new IntToken(i));
            }
            catch (NameDuplicationException ex) {
                throw new IllegalActionException((Nameable)this, ex, "couldn't clone/create");
            }
            clone.preinitialize();
        }
    }

    @Override
    public void wrapup() throws IllegalActionException {
        MultiInstanceComposite clone;
        super.wrapup();
        if (this._debugging) {
            this._debug(this.getFullName() + ".wrapup()");
        }
        if (!this._isMasterCopy) {
            return;
        }
        TypedCompositeActor container = (TypedCompositeActor)this.getContainer();
        if (container == null) {
            return;
        }
        int i = 1;
        while ((clone = (MultiInstanceComposite)container.getEntity(this.getName() + "_" + i)) != null) {
            ++i;
            for (TypedIOPort port : clone.portList()) {
                for (TypedIORelation relation : port.linkedRelationList()) {
                    TypedIOPort mirrorPort = (TypedIOPort)this.getPort(port.getName());
                    if (!port.isDeeplyConnected(mirrorPort)) {
                        try {
                            if (this._debugging) {
                                this._debug("Deleting " + relation.getFullName());
                            }
                            relation.setContainer(null);
                            continue;
                        }
                        catch (NameDuplicationException ex) {
                            throw new InternalErrorException(ex);
                        }
                    }
                    if (this._debugging) {
                        this._debug("Unlinking " + port.getFullName() + " from " + relation.getFullName());
                    }
                    port.unlink(relation);
                }
            }
            try {
                if (this._debugging) {
                    this._debug("Deleting " + clone.getFullName());
                }
                clone.setContainer(null);
            }
            catch (NameDuplicationException ex) {
                throw new InternalErrorException(ex);
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<group>\n");
        buffer.append("</group>");
        MoMLChangeRequest request = new MoMLChangeRequest(this, container, buffer.toString());
        request.setPersistent(false);
        this.requestChange(request);
    }

    private Object _cloneClone(Workspace workspace) throws CloneNotSupportedException {
        MultiInstanceComposite newObject = (MultiInstanceComposite)super.clone(workspace);
        newObject._isMasterCopy = false;
        newObject.setPersistent(false);
        try {
            new Attribute(newObject, "_hide");
        }
        catch (KernelException kernelException) {
            // empty catch block
        }
        return newObject;
    }

    private void _initialize() {
        this.setClassName("ptolemy.actor.lib.hoc.MultiInstanceComposite");
        try {
            this.nInstances = new Parameter((NamedObj)this, "nInstances", new IntToken(1));
            this.instance = new Parameter((NamedObj)this, "instance", new IntToken(0));
        }
        catch (Exception ex) {
            throw new InternalErrorException(this, (Throwable)ex, "Problem setting up instances or nInstances parameter");
        }
        this._isMasterCopy = true;
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-10\" width=\"60\" height=\"40\" style=\"fill:red\"/>\n<rect x=\"-18\" y=\"-8\" width=\"56\" height=\"36\" style=\"fill:lightgrey\"/>\n<rect x=\"-25\" y=\"-15\" width=\"60\" height=\"40\" style=\"fill:red\"/>\n<rect x=\"-23\" y=\"-13\" width=\"56\" height=\"36\" style=\"fill:lightgrey\"/>\n<rect x=\"-30\" y=\"-20\" width=\"60\" height=\"40\" style=\"fill:red\"/>\n<rect x=\"-28\" y=\"-18\" width=\"56\" height=\"36\" style=\"fill:lightgrey\"/>\n<rect x=\"-15\" y=\"-10\" width=\"10\" height=\"8\" style=\"fill:white\"/>\n<rect x=\"-15\" y=\"2\" width=\"10\" height=\"8\" style=\"fill:white\"/>\n<rect x=\"5\" y=\"-4\" width=\"10\" height=\"8\" style=\"fill:white\"/>\n<line x1=\"-5\" y1=\"-6\" x2=\"0\" y2=\"-6\"/><line x1=\"-5\" y1=\"6\" x2=\"0\" y2=\"6\"/><line x1=\"0\" y1=\"-6\" x2=\"0\" y2=\"6\"/><line x1=\"0\" y1=\"0\" x2=\"5\" y2=\"0\"/></svg>\n");
    }
}

