/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import ptolemy.actor.TimedActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.gui.Plotter;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.plot.Plot;

public class TimedPlotter
extends Plotter
implements TimedActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);

    public TimedPlotter(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setMultiport(true);
        this.input.setTypeEquals(BaseType.DOUBLE);
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        int width = this.input.getWidth();
        int offset = ((IntToken)this.startingDataset.getToken()).intValue();
        for (int i = width - 1; i >= 0; --i) {
            if (!this.input.hasToken(i)) continue;
            double currentTimeValue = this.input.getModelTime(i).getDoubleValue();
            DoubleToken currentToken = (DoubleToken)this.input.get(i);
            double currentValue = currentToken.doubleValue();
            ((Plot)this.plot).addPoint(i + offset, currentTimeValue, currentValue, true);
        }
        return super.postfire();
    }
}

