/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import java.awt.Container;
import ptolemy.actor.Manager;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.gui.SequencePlotter;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;
import ptolemy.plot.EditListener;
import ptolemy.plot.EditablePlot;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;

public class SketchedSource
extends SequencePlotter
implements EditListener {
    public Parameter initialTrace;
    public Parameter length;
    public TypedIOPort output = new TypedIOPort(this, "output", false, true);
    public Parameter periodic;
    public Parameter runOnModification;
    public Parameter yBottom;
    public Parameter yTop;
    private int _count;
    private double[][] _data;
    private boolean _dataModified = false;
    private boolean _initialTraceIsSet = false;
    private static IntToken _one = new IntToken(1);
    private int _previousLengthValue = -1;
    private boolean _settingInitialTrace = false;
    private static DoubleToken _zero = new DoubleToken(0.0);

    public SketchedSource(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.length = new Parameter((NamedObj)this, "length", new IntToken(100));
        this.length.setTypeEquals(BaseType.INT);
        this.initialTrace = new Parameter(this, "initialTrace");
        this.initialTrace.setExpression("repeat(length, 0.0)");
        this.initialTrace.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.initialTrace.setVisibility(Settable.EXPERT);
        this.periodic = new Parameter((NamedObj)this, "periodic", BooleanToken.TRUE);
        this.periodic.setTypeEquals(BaseType.BOOLEAN);
        this.yBottom = new Parameter((NamedObj)this, "yBottom", new DoubleToken(-1.0));
        this.yBottom.setTypeEquals(BaseType.DOUBLE);
        this.yTop = new Parameter((NamedObj)this, "yTop", new DoubleToken(1.0));
        this.yTop.setTypeEquals(BaseType.DOUBLE);
        this.runOnModification = new Parameter((NamedObj)this, "runOnModification", BooleanToken.FALSE);
        this.runOnModification.setTypeEquals(BaseType.BOOLEAN);
        this.fillOnWrapup.setToken(BooleanToken.FALSE);
        this.fillOnWrapup.setVisibility(Settable.NONE);
        this.startingDataset.setToken(_one);
        this.startingDataset.setVisibility(Settable.NONE);
        Parameter tokenInitProduction = new Parameter(this.output, "tokenInitProduction");
        tokenInitProduction.setExpression("length");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.length) {
            int lengthValue = ((IntToken)this.length.getToken()).intValue();
            if (lengthValue < 0) {
                throw new IllegalActionException((Nameable)this, "length: value is required to be positive.");
            }
            if (lengthValue != this._previousLengthValue) {
                this._previousLengthValue = lengthValue;
                this._initialTraceIsSet = false;
                this._showInitialTrace();
            }
        } else if (attribute == this.yBottom || attribute == this.yTop) {
            this._setRanges();
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        SketchedSource newObject = (SketchedSource)super.clone(workspace);
        this._data = null;
        this._dataModified = false;
        this._count = 0;
        this._initialTraceIsSet = false;
        this._previousLengthValue = -1;
        this._settingInitialTrace = false;
        return newObject;
    }

    @Override
    public synchronized void editDataModified(EditablePlot source, int dataset) {
        if (dataset == 0 && !this._settingInitialTrace) {
            this._dataModified = true;
            this._data = ((EditablePlot)this.plot).getData(0);
            try {
                Manager manager;
                boolean runValue = ((BooleanToken)this.runOnModification.getToken()).booleanValue();
                if (runValue && (manager = this.getManager()) != null && manager.getState() == Manager.IDLE) {
                    manager.execute();
                }
            }
            catch (KernelException ex) {
                throw new InternalErrorException(ex);
            }
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        boolean periodicValue = ((BooleanToken)this.periodic.getToken()).booleanValue();
        if (!periodicValue) {
            this.output.send(0, _zero);
            return;
        }
        ArrayToken arrayToken = (ArrayToken)this.initialTrace.getToken();
        this.output.send(0, arrayToken.getElement(this._count));
        ++this._count;
        if (this._count == arrayToken.length()) {
            this._count = 0;
            this._updateInitialTrace();
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        this.startingDataset.setToken(_one);
        this.fillOnWrapup.setToken(BooleanToken.FALSE);
        super.initialize();
        if (!this._initialTraceIsSet) {
            this._showInitialTrace();
        }
        this._updateInitialTrace();
        ArrayToken arrayToken = (ArrayToken)this.initialTrace.getToken();
        this.output.send(0, arrayToken.arrayValue(), arrayToken.length());
        this._count = 0;
    }

    @Override
    public void place(Container container) {
        super.place(container);
        if (container != null) {
            try {
                this._showInitialTrace();
            }
            catch (IllegalActionException ex) {
                throw new InternalErrorException(ex.getMessage());
            }
        }
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        this._stopRequested = false;
        this._createReceivers();
    }

    @Override
    protected PlotBox _newPlot() {
        EditablePlot result = new EditablePlot();
        result.addEditListener(this);
        return result;
    }

    private void _setRanges() throws IllegalActionException {
        if (this.plot == null) {
            return;
        }
        double xInitValue = ((DoubleToken)this.xInit.getToken()).doubleValue();
        double xUnitValue = ((DoubleToken)this.xUnit.getToken()).doubleValue();
        int lengthValue = ((IntToken)this.length.getToken()).intValue();
        this.plot.setXRange(xInitValue, xUnitValue * (double)lengthValue);
        double yBottomValue = ((DoubleToken)this.yBottom.getToken()).doubleValue();
        double yTopValue = ((DoubleToken)this.yTop.getToken()).doubleValue();
        this.plot.setYRange(yBottomValue, yTopValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _showInitialTrace() throws IllegalActionException {
        if (this.plot == null) {
            return;
        }
        try {
            this._settingInitialTrace = true;
            this._initialTraceIsSet = true;
            int lengthValue = ((IntToken)this.length.getToken()).intValue();
            ((Plot)this.plot).clear(0);
            boolean connected = false;
            ArrayToken defaultValues = (ArrayToken)this.initialTrace.getToken();
            for (int i = 0; i < lengthValue; ++i) {
                double value = 0.0;
                if (defaultValues != null && i < defaultValues.length()) {
                    value = ((DoubleToken)defaultValues.getElement(i)).doubleValue();
                }
                ((Plot)this.plot).addPoint(0, i, value, connected);
                connected = true;
            }
            this._setRanges();
            this.plot.repaint();
        }
        finally {
            this._settingInitialTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _updateInitialTrace() throws IllegalActionException {
        if (this._dataModified) {
            try {
                Token[] record = new Token[this._data[1].length];
                for (int i = 0; i < this._data[1].length; ++i) {
                    record[i] = new DoubleToken(this._data[1][i]);
                }
                ArrayToken newValue = new ArrayToken(BaseType.DOUBLE, record);
                this.initialTrace.setToken(newValue);
            }
            finally {
                this._dataModified = false;
            }
        }
    }
}

