/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import java.awt.Color;
import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.BadLocationException;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.gui.AbstractPlaceableActor;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.Placeable;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TextEditor;
import ptolemy.actor.gui.TextEffigy;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class Display
extends AbstractPlaceableActor {
    public Parameter columnsDisplayed;
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public Parameter rowsDisplayed;
    public Parameter suppressBlankLines;
    public transient JTextArea textArea;
    public StringAttribute title;
    private Container _container;
    private boolean _initialized = false;
    private int _previousNumColumns = 0;
    private int _previousNumRows = 0;
    private JScrollPane _scrollPane;
    private boolean _suppressBlankLines = false;

    public Display(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setMultiport(true);
        this.input.setTypeEquals(BaseType.GENERAL);
        this.rowsDisplayed = new Parameter(this, "rowsDisplayed");
        this.rowsDisplayed.setExpression("10");
        this.columnsDisplayed = new Parameter(this, "columnsDisplayed");
        this.columnsDisplayed.setExpression("40");
        this.suppressBlankLines = new Parameter(this, "suppressBlankLines");
        this.suppressBlankLines.setTypeEquals(BaseType.BOOLEAN);
        this.suppressBlankLines.setToken(BooleanToken.FALSE);
        this.title = new StringAttribute(this, "title");
        this.title.setExpression("");
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-15\" width=\"40\" height=\"30\" style=\"fill:lightGrey\"/>\n<rect x=\"-15\" y=\"-10\" width=\"30\" height=\"20\" style=\"fill:white\"/>\n<line x1=\"-13\" y1=\"-6\" x2=\"-4\" y2=\"-6\" style=\"stroke:grey\"/>\n<line x1=\"-13\" y1=\"-2\" x2=\"0\" y2=\"-2\" style=\"stroke:grey\"/>\n<line x1=\"-13\" y1=\"2\" x2=\"-8\" y2=\"2\" style=\"stroke:grey\"/>\n<line x1=\"-13\" y1=\"6\" x2=\"4\" y2=\"6\" style=\"stroke:grey\"/>\n</svg>\n");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.rowsDisplayed) {
            int numRows = ((IntToken)this.rowsDisplayed.getToken()).intValue();
            if (numRows <= 0) {
                throw new IllegalActionException((Nameable)this, "rowsDisplayed: requires a positive value.");
            }
            if (numRows != this._previousNumRows) {
                this._previousNumRows = numRows;
                if (this.textArea != null) {
                    this._paneSize.setToken((Token)null);
                    this.setFrame(this._frame);
                    this.textArea.setRows(numRows);
                    if (this._frame != null) {
                        this._frame.pack();
                        this._frame.setVisible(true);
                    }
                }
            }
        } else if (attribute == this.columnsDisplayed) {
            int numColumns = ((IntToken)this.columnsDisplayed.getToken()).intValue();
            if (numColumns <= 0) {
                throw new IllegalActionException((Nameable)this, "columnsDisplayed: requires a positive value.");
            }
            if (numColumns != this._previousNumColumns) {
                this._previousNumColumns = numColumns;
                if (this.textArea != null) {
                    this._paneSize.setToken((Token)null);
                    this.setFrame(this._frame);
                    this.textArea.setColumns(numColumns);
                    if (this._frame != null) {
                        this._frame.pack();
                        this._frame.setVisible(true);
                    }
                }
            }
        } else if (attribute == this.suppressBlankLines) {
            this._suppressBlankLines = ((BooleanToken)this.suppressBlankLines.getToken()).booleanValue();
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Display newObject = (Display)super.clone(workspace);
        newObject.textArea = null;
        return newObject;
    }

    public Color getBackground() {
        return this.textArea.getBackground();
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._initialized = false;
    }

    @Override
    public void place(Container container) {
        this._container = container;
        if (this._container == null) {
            if (this._frame != null) {
                this._frame.dispose();
            }
            this._frame = null;
            this._scrollPane = null;
            this.textArea = null;
            return;
        }
        this.textArea = new JTextArea();
        this._scrollPane = new JScrollPane(this.textArea);
        this._scrollPane.setBackground(null);
        this._scrollPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        this._scrollPane.setViewportBorder(new LineBorder(Color.black));
        this._container.add(this._scrollPane);
        this.textArea.setBackground(Color.white);
        String titleSpec = this.title.getExpression();
        if (!titleSpec.trim().equals("")) {
            this._scrollPane.setBorder(BorderFactory.createTitledBorder(titleSpec));
        }
        try {
            int numRows = ((IntToken)this.rowsDisplayed.getToken()).intValue();
            this.textArea.setRows(numRows);
            int numColumns = ((IntToken)this.columnsDisplayed.getToken()).intValue();
            this.textArea.setColumns(numColumns);
        }
        catch (IllegalActionException illegalActionException) {
            // empty catch block
        }
        this.textArea.setEditable(false);
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        int width = this.input.getWidth();
        boolean currentInputIsBlankLine = true;
        for (int i = 0; i < width; ++i) {
            if (!this.input.hasToken(i)) continue;
            Token token = this.input.get(i);
            if (!this._initialized) {
                this._initialized = true;
                this._openWindow();
            }
            if (this.textArea == null) continue;
            String value = token.toString();
            if (token instanceof StringToken) {
                value = ((StringToken)token).stringValue();
            }
            if (value.length() > 0) {
                currentInputIsBlankLine = false;
            }
            this.textArea.append(value);
            if (width > i + 1) {
                this.textArea.append("\n");
            }
            try {
                int lineOffset = this.textArea.getLineStartOffset(this.textArea.getLineCount() - 1);
                this.textArea.setCaretPosition(lineOffset);
                continue;
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
        if (!(this.textArea == null || this._suppressBlankLines && currentInputIsBlankLine)) {
            this.textArea.append("\n");
        }
        return super.postfire();
    }

    public void setBackground(Color background) {
        if (this._frame != null) {
            this._frame.setBackground(background);
        }
    }

    @Override
    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        NamedObj previousContainer = this.getContainer();
        super.setContainer(container);
        if (container != previousContainer && previousContainer != null) {
            this._remove();
        }
    }

    private void _openWindow() throws IllegalActionException {
        if (this.textArea == null) {
            Effigy containerEffigy = Configuration.findEffigy(this.toplevel());
            if (containerEffigy == null) {
                throw new IllegalActionException((Nameable)this, "Cannot find effigy for top level: " + this.toplevel().getFullName());
            }
            try {
                TextEffigy textEffigy = TextEffigy.newTextEffigy(containerEffigy, "");
                textEffigy.identifier.setExpression(this.getFullName());
                DisplayWindowTableau tableau = new DisplayWindowTableau(textEffigy, "tableau");
                this._frame = tableau.frame;
            }
            catch (Exception ex) {
                throw new IllegalActionException(this, null, ex, "Error creating effigy and tableau");
            }
            this.textArea = ((TextEditor)this._frame).text;
            int numRows = ((IntToken)this.rowsDisplayed.getToken()).intValue();
            this.textArea.setRows(numRows);
            int numColumns = ((IntToken)this.columnsDisplayed.getToken()).intValue();
            this.textArea.setColumns(numColumns);
            this.setFrame(this._frame);
            this._frame.pack();
        } else {
            this.textArea.setText(null);
        }
        if (this._frame != null) {
            this._frame.setVisible(true);
            this._frame.toFront();
        }
    }

    private void _remove() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Display.this.textArea != null) {
                    if (Display.this._container != null && Display.this._scrollPane != null) {
                        Display.this._container.remove(Display.this._scrollPane);
                        Display.this._container.invalidate();
                        Display.this._container.repaint();
                    } else if (Display.this._frame != null) {
                        Display.this._frame.dispose();
                    }
                }
            }
        });
    }

    private class DisplayWindowTableau
    extends Tableau {
        public TextEditor frame;

        public DisplayWindowTableau(TextEffigy container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
            String title = Display.this.title.getExpression();
            if (title.trim().equals("")) {
                title = Display.this.getFullName();
            }
            this.frame = new TextEditor(title, null, (Placeable)Display.this);
            this.setTitle(title);
            this.frame.text.setDocument(container.getDocument());
            this.setFrame(this.frame);
            this.frame.setTableau(this);
        }
    }
}

