/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.lib.conversions.Converter;
import ptolemy.data.ArrayToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.UnsignedByteToken;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class StringToUnsignedByteArray
extends Converter {
    public StringToUnsignedByteArray(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.STRING);
        this.output.setTypeEquals(new ArrayType(BaseType.UNSIGNED_BYTE));
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        String inputValue = ((StringToken)this.input.get(0)).stringValue();
        byte[] dataBytes = inputValue.getBytes();
        int bytesAvailable = dataBytes.length;
        Token[] dataTokens = new Token[bytesAvailable];
        for (int j = 0; j < bytesAvailable; ++j) {
            dataTokens[j] = new UnsignedByteToken(dataBytes[j]);
        }
        this.output.send(0, new ArrayToken(BaseType.UNSIGNED_BYTE, dataTokens));
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (!this.input.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

