/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ComplexToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.math.Complex;

public class PolarToComplex
extends TypedAtomicActor {
    public TypedIOPort magnitude = new TypedIOPort(this, "magnitude", true, false);
    public TypedIOPort angle;
    public TypedIOPort output;

    public PolarToComplex(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.magnitude.setTypeEquals(BaseType.DOUBLE);
        this.angle = new TypedIOPort(this, "angle", true, false);
        this.angle.setTypeEquals(BaseType.DOUBLE);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(BaseType.COMPLEX);
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-15,-15 15,15 15,-15 -15,15\" style=\"fill:white\"/>\n</svg>\n");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        double magnitudeValue = ((DoubleToken)this.magnitude.get(0)).doubleValue();
        double angleValue = ((DoubleToken)this.angle.get(0)).doubleValue();
        double xValue = magnitudeValue * Math.cos(angleValue);
        double yValue = magnitudeValue * Math.sin(angleValue);
        this.output.send(0, new ComplexToken(new Complex(xValue, yValue)));
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (!this.magnitude.hasToken(0) || !this.angle.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

