/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import java.util.Set;
import ptolemy.actor.lib.conversions.Converter;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ModelScope;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.ParserScope;
import ptolemy.data.expr.PtParser;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class ExpressionToToken
extends Converter {
    private PtParser _parser = null;
    private ParseTreeEvaluator _parseTreeEvaluator = null;
    private ParserScope _scope = null;

    public ExpressionToToken(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(BaseType.STRING);
        this.output.setTypeEquals(BaseType.GENERAL);
    }

    @Override
    public void fire() throws IllegalActionException {
        Token result;
        super.fire();
        String string = ((StringToken)this.input.get(0)).stringValue();
        try {
            if (this._parser == null) {
                this._parser = new PtParser();
            }
            ASTPtRootNode parseTree = this._parser.generateParseTree(string);
            if (this._parseTreeEvaluator == null) {
                this._parseTreeEvaluator = new ParseTreeEvaluator();
            }
            if (this._scope == null) {
                this._scope = new ExpressionScope();
            }
            result = this._parseTreeEvaluator.evaluateParseTree(parseTree, this._scope);
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Expression invalid.");
        }
        if (result == null) {
            throw new IllegalActionException((Nameable)this, "Expression yields a null result: " + string);
        }
        this.output.broadcast(result);
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (this.input.hasToken(0)) {
            return super.prefire();
        }
        return false;
    }

    @Override
    public void wrapup() {
        this._parser = null;
    }

    private class ExpressionScope
    extends ModelScope {
        private ExpressionScope() {
        }

        @Override
        public Token get(String name) throws IllegalActionException {
            Variable result = ExpressionScope.getScopedVariable(null, ExpressionToToken.this, name);
            if (result != null) {
                return result.getToken();
            }
            return null;
        }

        @Override
        public Type getType(String name) throws IllegalActionException {
            Variable result = ExpressionScope.getScopedVariable(null, ExpressionToToken.this, name);
            if (result != null) {
                return (Type)result.getTypeTerm().getValue();
            }
            return null;
        }

        @Override
        public InequalityTerm getTypeTerm(String name) throws IllegalActionException {
            Variable result = ExpressionScope.getScopedVariable(null, ExpressionToToken.this, name);
            if (result != null) {
                return result.getTypeTerm();
            }
            return null;
        }

        @Override
        public Set identifierSet() {
            return ExpressionScope.getAllScopedVariableNames(null, ExpressionToToken.this);
        }
    }
}

