/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.comm;

import ptolemy.actor.lib.comm.HuffmanBasic;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class HuffmanCoder
extends HuffmanBasic {
    public HuffmanCoder(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.alphabet.setTypeAtLeast(ArrayType.arrayOf(this.input));
        this.output.setTypeEquals(BaseType.BOOLEAN);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        HuffmanCoder newObject = (HuffmanCoder)super.clone(workspace);
        try {
            newObject.alphabet.setTypeAtLeast(ArrayType.arrayOf(newObject.input));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        ArrayToken alphabetArrayToken = (ArrayToken)this.alphabet.getToken();
        Token[] alphabetTokens = new Token[this._pmf.length];
        for (int i = 0; i < this._pmf.length; ++i) {
            alphabetTokens[i] = alphabetArrayToken.getElement(i);
        }
        Token inputToken = this.input.get(0);
        for (int i = 0; i < this._pmf.length; ++i) {
            if (!inputToken.equals(alphabetTokens[i])) continue;
            this._sendBooleans(this._codeBook[i]);
            break;
        }
    }

    private void _sendBooleans(String codeword) throws IllegalActionException {
        for (int i = 0; i < codeword.length(); ++i) {
            if (codeword.charAt(i) == '1') {
                this.output.send(0, new BooleanToken(true));
                continue;
            }
            this.output.send(0, new BooleanToken(false));
        }
    }
}

