/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import ptolemy.actor.lib.URLReader;
import ptolemy.data.BooleanToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class URLDirectoryReader
extends URLReader {
    public Parameter endsWith;
    public Parameter repeat;
    private String _endsWithValue;
    private int _iterationCount = 0;
    private String[] _data;
    private boolean _repeatFlag;

    public URLDirectoryReader(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.output.setTypeEquals(BaseType.STRING);
        this.endsWith = new Parameter((NamedObj)this, "endsWith", new StringToken(""));
        this.endsWith.setTypeEquals(BaseType.STRING);
        this.attributeChanged(this.endsWith);
        this.repeat = new Parameter((NamedObj)this, "repeat", new BooleanToken(false));
        this.repeat.setTypeEquals(BaseType.BOOLEAN);
        this.attributeChanged(this.repeat);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.repeat) {
            this._repeatFlag = ((BooleanToken)this.repeat.getToken()).booleanValue();
        } else if (attribute == this.endsWith) {
            StringToken endsWithToken = (StringToken)this.endsWith.getToken();
            this._endsWithValue = endsWithToken == null ? null : endsWithToken.stringValue();
        }
        super.attributeChanged(attribute);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.output.broadcast(new StringToken(this._data[this._iterationCount]));
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._iterationCount = 0;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        ++this._iterationCount;
        if (this._iterationCount >= this._data.length) {
            if (!this._repeatFlag) {
                return false;
            }
            this._iterationCount = 0;
            if (this._refreshFlag) {
                this._data = this._list(this._source, this._endsWithValue);
            }
        }
        return super.postfire();
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        try {
            this._data = this._list(this._source, this._endsWithValue);
            return super.prefire();
        }
        catch (Exception ex) {
            throw new IllegalActionException((Nameable)this, ex, "prefire() failed");
        }
    }

    private String[] _list(String source, String endsWith) throws IllegalActionException {
        if (source.startsWith("file:")) {
            return this._listFile(source, endsWith);
        }
        try {
            return URLDirectoryReader._listFileOrURL(source, endsWith);
        }
        catch (Exception ex) {
            throw new IllegalActionException("Could not open '" + source + ": " + KernelException.stackTraceToString(ex));
        }
    }

    private String[] _listFile(String source, String endsWith) throws IllegalActionException {
        try {
            URL sourceURL = new URL(source);
            if (sourceURL.getProtocol().equals("file")) {
                File file = new File(sourceURL.getFile());
                if (file.isDirectory()) {
                    if (!source.endsWith("/")) {
                        source = source + "/";
                    }
                    File[] files = file.listFiles();
                    LinkedList<String> resultsList = new LinkedList<String>();
                    for (int i = 0; i < files.length; ++i) {
                        String filename = files[i].getName();
                        if (endsWith != null && endsWith.length() != 0 && !filename.endsWith(endsWith)) continue;
                        resultsList.add(source + filename);
                    }
                    String[] results = new String[resultsList.size()];
                    return resultsList.toArray(results);
                }
                if (file.isFile()) {
                    return new String[]{file.toString()};
                }
                throw new IllegalActionException("'" + source + "' is neither a file " + "or a directory?");
            }
            throw new IllegalActionException("'" + source + "' does not " + "have the file: protocol");
        }
        catch (Exception ex) {
            throw new IllegalActionException("Could not open '" + source + "' :" + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] _listFileOrURL(String source, String endsWith) throws MalformedURLException, IOException {
        URL url = new URL(source);
        URLConnection urlConnection = url.openConnection();
        String contentType = urlConnection.getContentType();
        if (!contentType.startsWith("text/html") && !contentType.startsWith("text/plain")) {
            throw new RuntimeException("Could not parse '" + source + "', it is not \"text/html\", " + "or \"text/plain\", it is: " + urlConnection.getContentType());
        }
        LinkedList<String> resultsList = new LinkedList<String>();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            if (!contentType.startsWith("text/plain") && !urlConnection.getURL().toString().endsWith("/")) {
                throw new RuntimeException("Could not parse '" + source + "', it does not end with '/'");
            }
            if (!source.endsWith("/")) {
                source = source + "/";
            }
            String target = null;
            boolean sawBody = false;
            boolean sawHREF = false;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).startsWith("<BODY") || line.startsWith("<body")) {
                    sawBody = true;
                    continue;
                }
                if (!sawBody) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, "<\" >=");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (token.compareToIgnoreCase("HREF") == 0) {
                        sawHREF = true;
                        target = null;
                        continue;
                    }
                    if (!sawHREF) continue;
                    if (target == null) {
                        target = token;
                        continue;
                    }
                    if (token.compareTo(target) != 0) {
                        sawHREF = false;
                        continue;
                    }
                    if (endsWith == null || endsWith.length() == 0 || target.endsWith(endsWith)) {
                        resultsList.add(source + target);
                    }
                    sawHREF = false;
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        String[] results = new String[resultsList.size()];
        return resultsList.toArray(results);
    }
}

