/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.LongToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class Sleep
extends Transformer {
    public PortParameter sleepTime = new PortParameter(this, "sleepTime");
    private boolean _wasSleepCalledInFireYet = false;

    public Sleep(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.sleepTime.setExpression("0L");
        this.sleepTime.setTypeEquals(BaseType.LONG);
        ParameterPort sleepPort = this.sleepTime.getPort();
        StringAttribute sleepCardinal = new StringAttribute(sleepPort, "_cardinal");
        sleepCardinal.setExpression("SOUTH");
        this.input.setMultiport(true);
        this.output.setMultiport(true);
        this.output.setTypeAtLeast(this.input);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Sleep newObject = (Sleep)super.clone(workspace);
        newObject.output.setTypeAtLeast(newObject.input);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        if (!this._wasSleepCalledInFireYet) {
            this._wasSleepCalledInFireYet = true;
            super.fire();
            this.sleepTime.update();
            int inputWidth = this.input.getWidth();
            Token[] inputs = new Token[inputWidth];
            for (int i = 0; i < inputWidth; ++i) {
                if (!this.input.hasToken(i)) continue;
                inputs[i] = this.input.get(i);
            }
            try {
                long sleepTimeValue = ((LongToken)this.sleepTime.getToken()).longValue();
                if (this._debugging) {
                    this._debug(this.getName() + ": Wait for " + sleepTimeValue + " milliseconds.");
                }
                Thread.sleep(sleepTimeValue);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            int outputWidth = this.output.getWidth();
            for (int i = 0; i < inputWidth; ++i) {
                if (inputs[i] == null || i >= outputWidth) continue;
                this.output.send(i, inputs[i]);
            }
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._wasSleepCalledInFireYet = false;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this._wasSleepCalledInFireYet = false;
        return super.postfire();
    }
}

