/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.Director;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.actor.lib.Subscriber;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class Publisher
extends TypedAtomicActor {
    public StringParameter channel = new StringParameter(this, "channel");
    public TypedIOPort input;
    public TypedIOPort output;
    protected String _channel;
    protected TypedIORelation _relation;
    protected boolean _updatedLinks = false;
    private boolean _inConnectionsChanged = false;
    private boolean _running;

    public Publisher(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.channel.setExpression(this._uniqueChannelName());
        this.input = new TypedIOPort(this, "input", true, false);
        this.input.setMultiport(true);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setMultiport(true);
        SingletonParameter hide = new SingletonParameter(this.output, "_hide");
        hide.setToken(BooleanToken.TRUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.channel) {
            String newValue;
            if (this.isWithinClassDefinition() || (newValue = this.channel.stringValue()).equals(this._channel)) return;
            this._channel = newValue;
            NamedObj container = this.getContainer();
            if (!(container instanceof TypedCompositeActor)) return;
            try {
                this._updateLinks();
                return;
            }
            catch (IllegalActionException ex) {
                this._updatedLinks = false;
                if (!this._running) return;
                throw ex;
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Publisher newObject = (Publisher)super.clone(workspace);
        try {
            newObject._updatedLinks = false;
        }
        catch (Throwable throwable) {
            CloneNotSupportedException exception = new CloneNotSupportedException();
            exception.initCause(throwable);
            throw exception;
        }
        return newObject;
    }

    @Override
    public void connectionsChanged(Port port) {
        super.connectionsChanged(port);
        if (port == this.input && this._relation != null && !this._inConnectionsChanged) {
            try {
                this._inConnectionsChanged = true;
                int width = this.input.getWidth();
                this._relation.setWidth(width);
            }
            catch (IllegalActionException e) {
                throw new InternalErrorException(e);
            }
            finally {
                this._inConnectionsChanged = false;
            }
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        for (int i = 0; i < this.input.getWidth(); ++i) {
            if (!this.input.hasToken(i)) continue;
            Token token = this.input.get(i);
            this.output.send(i, token);
        }
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        this._running = true;
        if (!this._updatedLinks) {
            this._updateLinks();
        }
    }

    @Override
    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        if (container == null && this._relation != null) {
            try {
                this._relation.setContainer(null);
            }
            catch (NameDuplicationException e) {
                throw new InternalErrorException(e);
            }
            this._relation = null;
        }
        super.setContainer(container);
    }

    @Override
    public void wrapup() throws IllegalActionException {
        super.wrapup();
        this._running = false;
    }

    protected void _updateLinks() throws IllegalActionException {
        Director director;
        NamedObj container;
        if (this._channel == null) {
            return;
        }
        Iterator subscribers = this._findSubscribers().iterator();
        if (this._relation != null) {
            try {
                this._relation.setContainer(null);
            }
            catch (NameDuplicationException e) {
                throw new InternalErrorException(e);
            }
            this._relation = null;
        }
        if ((container = this.getContainer()) instanceof TypedCompositeActor) {
            try {
                this._relation = new TypedIORelation((TypedCompositeActor)container, container.uniqueName("publisherRelation"));
                this._relation.setPersistent(false);
                new Parameter((NamedObj)this._relation, "_hide", BooleanToken.TRUE);
                this._relation.setWidth(this.input.getWidth());
            }
            catch (NameDuplicationException e) {
                throw new InternalErrorException(e);
            }
            this.output.link(this._relation);
            while (subscribers.hasNext()) {
                Subscriber subscriber = (Subscriber)subscribers.next();
                subscriber.input.liberalLink(this._relation);
            }
        }
        if ((director = this.getDirector()) != null) {
            director.invalidateSchedule();
            director.invalidateResolvedTypes();
        }
        this._updatedLinks = true;
    }

    private List _findSubscribers() throws IllegalActionException {
        CompositeEntity container;
        LinkedList result = new LinkedList();
        for (container = (CompositeEntity)this.getContainer(); container != null && !container.isOpaque(); container = (CompositeEntity)container.getContainer()) {
        }
        if (container != null) {
            for (Object actor : container.deepEntityList()) {
                if (actor instanceof Subscriber) {
                    if (!((Subscriber)actor).channelMatches(this._channel)) continue;
                    result.add(actor);
                    continue;
                }
                if (!(actor instanceof Publisher) || actor == this || !this._channel.equals(((Publisher)actor)._channel)) continue;
                throw new IllegalActionException((Nameable)this, "There is already a publisher using channel \"" + this._channel + "\": " + ((NamedObj)actor).getFullName());
            }
        }
        return result;
    }

    private String _uniqueChannelName() {
        CompositeEntity container;
        int suffix = 1;
        for (container = (CompositeEntity)this.getContainer(); container != null && !container.isOpaque(); container = (CompositeEntity)container.getContainer()) {
        }
        if (container != null) {
            for (Object actor : container.deepEntityList()) {
                String nameInUse;
                if (!(actor instanceof Publisher) || actor == this || (nameInUse = ((Publisher)actor)._channel) == null || !nameInUse.startsWith("channel")) continue;
                String suffixInUse = nameInUse.substring(7);
                try {
                    int suffixAsInt = Integer.parseInt(suffixInUse);
                    if (suffix > suffixAsInt) continue;
                    suffix = suffixAsInt + 1;
                }
                catch (NumberFormatException ex) {}
            }
        }
        return "channel" + suffix;
    }
}

