/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.lib.TimedSource;
import ptolemy.actor.util.Time;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class PoissonClock
extends TimedSource {
    public Parameter fireAtStart;
    public Parameter meanTime = new Parameter(this, "meanTime");
    public Parameter values;
    private transient int _length;
    private transient int _tentativeCurrentOutputIndex;
    private transient int _currentOutputIndex;
    private transient Time _nextFiringTime;
    private transient boolean _boundaryCrossed;

    public PoissonClock(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.meanTime.setExpression("1.0");
        this.meanTime.setTypeEquals(BaseType.DOUBLE);
        this.values = new Parameter(this, "values");
        this.values.setExpression("{1, 0}");
        this.output.setTypeAtLeast(ArrayType.elementType(this.values));
        this.attributeChanged(this.values);
        this.fireAtStart = new Parameter(this, "fireAtStart");
        this.fireAtStart.setExpression("true");
        this.fireAtStart.setTypeEquals(BaseType.BOOLEAN);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.meanTime) {
            double mean = ((DoubleToken)this.meanTime.getToken()).doubleValue();
            if (mean <= 0.0) {
                throw new IllegalActionException((Nameable)this, "meanTime is required to be positive.  meanTime given: " + mean);
            }
        } else if (attribute == this.values) {
            ArrayToken val = (ArrayToken)this.values.getToken();
            this._length = val.length();
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        PoissonClock newObject = (PoissonClock)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType(newObject.values));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        Time currentTime = this.getDirector().getModelTime();
        this._boundaryCrossed = false;
        this._tentativeCurrentOutputIndex = this._currentOutputIndex;
        this.output.send(0, this._getValue(this._tentativeCurrentOutputIndex));
        if (currentTime.compareTo(this._nextFiringTime) == 0) {
            ++this._tentativeCurrentOutputIndex;
            if (this._tentativeCurrentOutputIndex >= this._length) {
                this._tentativeCurrentOutputIndex = 0;
            }
            this._boundaryCrossed = true;
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        Time currentTime;
        super.initialize();
        this._tentativeCurrentOutputIndex = 0;
        this._currentOutputIndex = 0;
        this._nextFiringTime = currentTime = this.getDirector().getModelTime();
        if (((BooleanToken)this.fireAtStart.getToken()).booleanValue()) {
            this.getDirector().fireAt((Actor)this, currentTime);
        } else {
            double meanTimeValue = ((DoubleToken)this.meanTime.getToken()).doubleValue();
            double exp = -Math.log(1.0 - Math.random()) * meanTimeValue;
            Director director = this.getDirector();
            this._nextFiringTime = director.getModelTime().add(exp);
            director.fireAt((Actor)this, this._nextFiringTime);
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this._currentOutputIndex = this._tentativeCurrentOutputIndex;
        if (this._boundaryCrossed) {
            double meanTimeValue = ((DoubleToken)this.meanTime.getToken()).doubleValue();
            double exp = -Math.log(1.0 - Math.random()) * meanTimeValue;
            Director director = this.getDirector();
            this._nextFiringTime = director.getModelTime().add(exp);
            director.fireAt((Actor)this, this._nextFiringTime);
        }
        return super.postfire();
    }

    private Token _getValue(int index) throws IllegalActionException {
        ArrayToken val = (ArrayToken)this.values.getToken();
        if (val == null || index >= this._length) {
            throw new IllegalActionException((Nameable)this, "Index out of range of the values parameter.");
        }
        return val.getElement(index);
    }
}

