/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class MovingAverage
extends Transformer {
    public Parameter maxPastInputsToAverage = new Parameter(this, "maxPastInputsToAverage");
    protected Token[] _data;
    protected int _mostRecent;
    protected int _count;
    protected int _maxPastInputsToAverage = 10;
    protected boolean _reinitializeNeeded = true;
    private DoubleToken _factor;

    public MovingAverage(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.maxPastInputsToAverage.setTypeEquals(BaseType.INT);
        this.maxPastInputsToAverage.setExpression("10");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.maxPastInputsToAverage) {
            this._maxPastInputsToAverage = ((IntToken)this.maxPastInputsToAverage.getToken()).intValue();
            if (this._maxPastInputsToAverage <= 0) {
                throw new IllegalActionException((Nameable)this, "Value of maxPastInputsToAverage is required to be positive.");
            }
            this._reinitializeNeeded = true;
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this._mostRecent = this._mostRecent <= 0 ? this._maxPastInputsToAverage - 1 : --this._mostRecent;
        this._data[this._mostRecent] = this.input.get(0);
        if (this._count < this._maxPastInputsToAverage) {
            ++this._count;
            this._factor = new DoubleToken(1.0 / (double)this._count);
        }
        Token sum = this._data[this._mostRecent];
        for (int i = 1; i < this._count; ++i) {
            int dataIndex = (this._mostRecent + i) % this._data.length;
            sum = sum.add(this._data[dataIndex]);
        }
        this.output.send(0, this._factor.multiply(sum));
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (this._reinitializeNeeded) {
            this._reinitialize();
        }
        if (this.input.hasToken(0)) {
            return super.prefire();
        }
        if (this._debugging) {
            this._debug("Called prefire(), which returns false.");
        }
        return false;
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._data = null;
        this._reinitializeNeeded = true;
    }

    protected void _reinitialize() throws IllegalActionException {
        int length = this._maxPastInputsToAverage;
        this._data = new Token[length];
        this._count = 0;
        this._mostRecent = this._maxPastInputsToAverage;
        this._reinitializeNeeded = false;
    }
}

