/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Iterator;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.data.BooleanToken;
import ptolemy.data.ComplexToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.FixToken;
import ptolemy.data.IntToken;
import ptolemy.data.LongToken;
import ptolemy.data.RecordToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ConversionUtilities;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.math.Complex;
import ptolemy.math.FixPoint;

public class ClassWrapper
extends TypedAtomicActor {
    public StringAttribute className = new StringAttribute(this, "className");
    private Hashtable _methodTable = null;
    private Object _instance = null;
    private Class _class = null;

    public ClassWrapper(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        for (IOPort inPort : this.inputPortList()) {
            if (!inPort.hasToken(0)) continue;
            this._invoke(inPort, inPort.get(0));
        }
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        try {
            this._class = Class.forName(this.className.getExpression());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Cannot find specified class " + this.className.getExpression());
        }
        this._methodTable = new Hashtable();
        Method[] methods = this._class.getMethods();
        Iterator inPorts = this.inputPortList().iterator();
        boolean needInstance = false;
        while (inPorts.hasNext()) {
            IOPort outPort;
            IOPort inPort = (IOPort)inPorts.next();
            String portName = inPort.getName();
            Method m = null;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(portName)) continue;
                m = methods[i];
                break;
            }
            if (m == null) {
                throw new IllegalActionException((Nameable)this, "The specified class does not have a method of the same name as input port " + portName);
            }
            Object[] methodInfo = new Object[]{m, m.getParameterTypes(), (outPort = (IOPort)this.getPort(portName + "Result")) != null && outPort.isOutput() ? outPort : null};
            this._methodTable.put(inPort, methodInfo);
            if (Modifier.isStatic(m.getModifiers())) continue;
            needInstance = true;
        }
        this._instance = null;
        if (needInstance) {
            try {
                Constructor constructor = this._class.getConstructor(new Class[0]);
                this._instance = constructor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalActionException((Nameable)this, ex, "Cannot create an instance of the specified class");
            }
        }
    }

    private void _invoke(IOPort port, Token argv) throws IllegalActionException {
        Object[] methodInfo = (Object[])this._methodTable.get(port);
        Method m = (Method)methodInfo[0];
        Class[] argTypes = (Class[])methodInfo[1];
        int args = argTypes.length;
        IOPort outPort = (IOPort)methodInfo[2];
        Object[] argValues = new Object[args];
        if (args > 0) {
            RecordToken argRecord = null;
            if (argv instanceof RecordToken) {
                argRecord = (RecordToken)argv;
            } else if (args > 1) {
                throw new IllegalActionException((Nameable)this, "cannot convert input token to method call arguments.");
            }
            for (int i = 0; i < args; ++i) {
                Token arg = null;
                arg = argRecord != null ? argRecord.get("arg" + (i + 1)) : argv;
                argValues[i] = argTypes[i].isAssignableFrom(arg.getClass()) ? arg : ConversionUtilities.convertTokenToJavaType(arg);
            }
        }
        Object result = null;
        try {
            result = m.invoke(this._instance, argValues);
        }
        catch (InvocationTargetException ex) {
            ex.getTargetException().printStackTrace();
            throw new IllegalActionException((Nameable)this, ex.getTargetException(), "Error invoking method " + m.getName());
        }
        catch (Exception ex) {
            throw new IllegalActionException((Nameable)this, ex, "Error invoking method " + m.getName());
        }
        Token resultToken = null;
        if (result == null) {
            return;
        }
        if (result instanceof Token) {
            resultToken = (Token)result;
        } else if (result instanceof Double) {
            resultToken = new DoubleToken((Double)result);
        } else if (result instanceof Integer) {
            resultToken = new IntToken((Integer)result);
        } else if (result instanceof Long) {
            resultToken = new LongToken((Long)result);
        } else if (result instanceof String) {
            resultToken = new StringToken((String)result);
        } else if (result instanceof Boolean) {
            resultToken = new BooleanToken((Boolean)result);
        } else if (result instanceof Complex) {
            resultToken = new ComplexToken((Complex)result);
        } else if (result instanceof FixPoint) {
            resultToken = new FixToken((FixPoint)result);
        } else {
            throw new IllegalActionException((Nameable)this, "Result of method call " + port.getName() + " is not a supported type: boolean, " + "complex, fixpoint, double, int, long  and String, " + "or a Token.");
        }
        if (outPort != null) {
            outPort.send(0, resultToken);
        }
    }
}

