/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.URL;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.JNLPUtilities;
import ptolemy.actor.gui.ModelDirectory;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.moml.LibraryBuilder;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.moml.MoMLParser;
import ptolemy.util.StringUtilities;

public class UserActorLibrary {
    public static String USER_LIBRARY_NAME = "UserLibrary";

    public static void openUserLibrary(Configuration configuration) throws Exception {
        String libraryName = null;
        try {
            libraryName = StringUtilities.preferencesDirectory() + USER_LIBRARY_NAME + ".xml";
        }
        catch (Exception ex) {
            System.out.println("Warning: Failed to get the preferences directory (-sandbox always causes this): " + ex);
        }
        if (libraryName != null) {
            String oldLibraryName;
            File oldFile;
            File file = new File(libraryName);
            if (!(file.isFile() && file.exists() || !(oldFile = new File(oldLibraryName = StringUtilities.preferencesDirectory() + "user library.xml")).isFile() || !oldFile.exists() || oldFile.renameTo(file))) {
                throw new IOException("Failed to rename \"" + oldFile + "\" to \"" + file + "\".");
            }
            if (!file.isFile() || !file.exists()) {
                OutputStreamWriter writer = null;
                try {
                    if (!file.createNewFile()) {
                        throw new Exception(file + "already exists?");
                    }
                    writer = new FileWriter(file);
                    writer.write("<entity name=\"" + USER_LIBRARY_NAME + "\" class=\"ptolemy.moml.EntityLibrary\"/>");
                    writer.close();
                }
                catch (Exception ex) {
                    throw new Exception("Failed to create an empty user library: " + libraryName, ex);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            UserActorLibrary.openLibrary(configuration, file);
        }
    }

    public static void openLibrary(Configuration configuration, File file) throws Exception {
        URL fileURL;
        String identifier;
        Effigy libraryEffigy;
        CompositeEntity library = null;
        CompositeEntity libraryContainer = (CompositeEntity)configuration.getEntity("actor library");
        ModelDirectory directory = (ModelDirectory)configuration.getEntity("directory");
        if (directory == null) {
            return;
        }
        if (libraryContainer == null) {
            return;
        }
        StringAttribute alternateLibraryBuilderAttribute = (StringAttribute)libraryContainer.getAttribute("_alternateLibraryBuilder");
        if (alternateLibraryBuilderAttribute != null) {
            String libraryBuilderClassName = alternateLibraryBuilderAttribute.getExpression();
            Class<?> libraryBuilderClass = Class.forName(libraryBuilderClassName);
            LibraryBuilder libraryBuilder = (LibraryBuilder)libraryBuilderClass.newInstance();
            libraryBuilder.addAttributes(alternateLibraryBuilderAttribute.attributeList());
            try {
                library = libraryBuilder.buildLibrary(libraryContainer.workspace());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Exception("Cannot create library with LibraryBuilder: ", ex);
            }
        }
        if ((libraryEffigy = directory.getEffigy(identifier = (fileURL = JNLPUtilities.canonicalizeJarURL(file.toURI().toURL())).toExternalForm())) == null) {
            if (library == null) {
                MoMLParser parser = new MoMLParser(libraryContainer.workspace());
                parser.parse(fileURL, fileURL);
                library = (CompositeEntity)parser.getToplevel();
            }
            PtolemyEffigy finalLibraryEffigy = new PtolemyEffigy(directory.workspace());
            finalLibraryEffigy.setSystemEffigy(true);
            if (library.getName().equals("user library")) {
                library.setName(USER_LIBRARY_NAME);
            }
            finalLibraryEffigy.setName(directory.uniqueName(library.getName()));
            UserActorLibrary._instantiateLibrary(library, directory, configuration, file, libraryContainer, finalLibraryEffigy);
            finalLibraryEffigy.setModel(library);
            URIAttribute uri = new URIAttribute(library, "_uri");
            uri.setURL(fileURL);
            finalLibraryEffigy.uri.setURL(fileURL);
            finalLibraryEffigy.identifier.setExpression(identifier);
        }
    }

    public static void saveComponentInLibrary(Configuration configuration, Entity entity) throws IOException, IllegalActionException {
        if (entity == null) {
            throw new NullPointerException("Save in library failed. entity was null, cannot save a null entity.");
        }
        try {
            CompositeEntity libraryInstance = (CompositeEntity)configuration.getEntity("actor library." + USER_LIBRARY_NAME);
            if (libraryInstance == null) {
                throw new IOException("Save In Library failed: Could not find user library with name \"" + USER_LIBRARY_NAME + "\".");
            }
            Tableau libraryTableau = configuration.openModel(libraryInstance);
            PtolemyEffigy libraryEffigy = (PtolemyEffigy)libraryTableau.getContainer();
            CompositeEntity library = (CompositeEntity)libraryEffigy.getModel();
            StringWriter buffer = new StringWriter();
            if (library == null) {
                throw new InternalErrorException("Save in library failed. libraryEffigy.getModel() returned null.");
            }
            if (library.getEntity(entity.getName()) != null) {
                throw new NameDuplicationException((Nameable)entity, "Save In Library failed: An object already exists in the user library with name \"" + entity.getName() + "\".");
            }
            entity.exportMoML(buffer, 1);
            MoMLChangeRequest request = new MoMLChangeRequest(entity, library, buffer.toString());
            library.requestChange(request);
        }
        catch (IOException ex) {
        }
        catch (KernelException kernelException) {
            // empty catch block
        }
    }

    private static void _instantiateLibrary(final CompositeEntity library, final ModelDirectory directory, Configuration configuration, File file, final CompositeEntity libraryContainer, final PtolemyEffigy finalLibraryEffigy) throws Exception {
        ChangeRequest request = new ChangeRequest(configuration, file.toURI().toURL().toString()){

            @Override
            protected void _execute() throws Exception {
                library.setClassDefinition(true);
                library.instantiate(libraryContainer, library.getName());
                finalLibraryEffigy.setContainer(directory);
            }
        };
        libraryContainer.requestChange(request);
        request.waitForCompletion();
    }
}

