/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Manager;
import ptolemy.actor.gui.DialogTableau;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.actor.gui.WindowPropertiesAttribute;
import ptolemy.data.expr.FileParameter;
import ptolemy.gui.Query;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.undo.UndoStackAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.BasicModelErrorHandler;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NamedObj;

public abstract class PtolemyFrame
extends TableauFrame {
    private NamedObj _model;
    private Query _query;

    public PtolemyFrame(NamedObj model) {
        this(model, null);
    }

    public PtolemyFrame(NamedObj model, Tableau tableau) {
        super(tableau);
        LinkedList<String> extensions = new LinkedList<String>();
        extensions.add("xml");
        extensions.add("moml");
        extensions.add("XML");
        extensions.add("MOML");
        extensions.add("MoML");
        this._fileFilter = new TableauFrame.ExtensionFileFilter(extensions);
        this.setModel(model);
        try {
            WindowPropertiesAttribute properties = (WindowPropertiesAttribute)model.getAttribute("_windowProperties", WindowPropertiesAttribute.class);
            if (properties != null) {
                properties.setProperties(this);
            }
        }
        catch (IllegalActionException ex) {
            // empty catch block
        }
    }

    public NamedObj getModel() {
        return this._model;
    }

    public void setModel(NamedObj model) {
        this._model = model;
        this._model.setModelErrorHandler(new BasicModelErrorHandler());
        List attrList = this._model.attributeList(UndoStackAttribute.class);
        if (attrList.size() == 0) {
            try {
                new UndoStackAttribute(this._model, "_undoInfo");
            }
            catch (KernelException e) {
                throw new InternalErrorException(e);
            }
        }
    }

    @Override
    protected boolean _clear() {
        if (super._clear()) {
            this.setModel(new CompositeEntity());
            return true;
        }
        return false;
    }

    @Override
    protected boolean _close() {
        PtolemyEffigy ptolemyEffigy = (PtolemyEffigy)this.getEffigy();
        if (ptolemyEffigy != null) {
            List tableaux = ptolemyEffigy.entityList(Tableau.class);
            for (Tableau tableau : tableaux) {
                DialogTableau dialogTableau;
                if (!(tableau instanceof DialogTableau) || (dialogTableau = (DialogTableau)tableau).close()) continue;
                return false;
            }
        }
        return super._close();
    }

    @Override
    protected void _help() {
        try {
            FileParameter helpAttribute = (FileParameter)this.getModel().getAttribute("_help", FileParameter.class);
            URL doc = helpAttribute.asURL();
            this.getConfiguration().openModel(null, doc, doc.toExternalForm());
        }
        catch (Exception ex) {
            super._help();
        }
    }

    @Override
    protected void _print() {
        if (this._model != null) {
            ChangeRequest request = new ChangeRequest(this, "Print"){

                @Override
                protected void _execute() throws Exception {
                    PtolemyFrame.super._print();
                }
            };
            this._model.requestChange(request);
        } else {
            super._print();
        }
    }

    @Override
    protected boolean _saveAs() {
        Manager manager;
        if (this._model != null) {
            this._initialSaveAsFileName = this._model.toplevel().getName() + ".xml";
            if (this._initialSaveAsFileName.length() == 4) {
                this._initialSaveAsFileName = "model.xml";
            }
        } else {
            this._initialSaveAsFileName = "model.xml";
        }
        if (this._model instanceof CompositeActor && (manager = ((CompositeActor)this._model).getManager()) != null) {
            Manager.State state = manager.getState();
            if (state == Manager.IDLE && state == Manager.PAUSED) {
                return super._saveAs();
            }
            manager.pause();
            boolean returnValue = super._saveAs();
            manager.resume();
            return returnValue;
        }
        return super._saveAs(".xml");
    }

    @Override
    protected JFileChooser _saveAsFileDialog() {
        JFileChooser fileDialog = super._saveAsFileDialog();
        if (this._model != null && this._model.getContainer() != null) {
            this._query = new Query();
            this._query.addCheckBox("submodel", "Save submodel only", false);
            fileDialog.setAccessory(this._query);
        }
        return fileDialog;
    }

    @Override
    protected void _writeFile(File file) throws IOException {
        Effigy effigy;
        Tableau tableau = this.getTableau();
        if (tableau != null && (effigy = (Effigy)tableau.getContainer()) != null) {
            if (this._model != null) {
                for (Attribute attribute : this._model.attributeList(Attribute.class)) {
                    attribute.updateContent();
                }
            }
            if (this._model == null) {
                effigy = effigy.topEffigy();
            } else if (this._query == null || this._model.getContainer() != null && !this._query.getBooleanValue("submodel")) {
                effigy = effigy.masterEffigy();
            }
            effigy.writeFile(file);
            return;
        }
        throw new IOException("Cannot find an effigy to delegate writing.");
    }
}

