/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.DialogTableau;
import ptolemy.kernel.Entity;
import ptolemy.util.MessageHandler;

public abstract class PtolemyDialog
extends JFrame
implements ActionListener {
    protected Configuration _configuration;
    protected JButton _helpButton;
    protected JButton _cancelButton;
    private JComponent _contents;
    private boolean _dirty = false;
    private DialogTableau _dialogTableau;
    private Frame _owner;
    private Entity _target;

    public PtolemyDialog(String title, DialogTableau dialogTableau, Frame owner, Entity target, Configuration configuration) {
        super(title);
        this._owner = owner;
        this._dialogTableau = dialogTableau;
        this._target = target;
        this._configuration = configuration;
        this._dialogTableau.setTitle(title);
        JPanel _buttons = this._createButtonsPanel();
        this.getContentPane().add((Component)_buttons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PtolemyDialog.this._cancel();
            }
        });
        this._owner.addWindowListener(new WindowAdapter(){

            @Override
            public void windowIconified(WindowEvent e) {
                PtolemyDialog.this._iconify();
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                PtolemyDialog.this._deiconify();
            }
        });
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] SCREENS = ge.getScreenDevices();
        Point ownerLoc = owner.getLocation();
        Rectangle screenBounds = null;
        for (int screen = 0; screen < SCREENS.length; ++screen) {
            GraphicsConfiguration gc = SCREENS[screen].getDefaultConfiguration();
            Rectangle bounds = gc.getBounds();
            if (!bounds.contains(ownerLoc)) continue;
            screenBounds = bounds;
            break;
        }
        if (screenBounds != null) {
            Dimension size = this.getPreferredSize();
            int x = screenBounds.x + screenBounds.width / 2 - size.width / 2;
            int y = screenBounds.y + screenBounds.height / 2 - size.height / 2;
            this.setLocation(x, y);
        } else {
            this.setLocationRelativeTo(this._owner);
        }
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        String command = aEvent.getActionCommand();
        if (aEvent.getSource() instanceof JButton) {
            this._processButtonPress(command);
        }
    }

    public Entity getTarget() {
        return this._target;
    }

    public void saveIfRequired() {
    }

    public void setContents(JComponent contents) {
        this._contents = contents;
        this.getContentPane().add((Component)this._contents, "Center");
    }

    public void setScrollableContents(JComponent contents) {
        this._contents = contents;
        JScrollPane scrollPane = new JScrollPane(this._contents);
        this.getContentPane().add((Component)scrollPane, "Center");
    }

    public void setTarget(Entity entity) {
        this._target = entity;
    }

    protected void _cancel() {
        this.saveIfRequired();
        this.dispose();
    }

    protected abstract void _createExtendedButtons(JPanel var1);

    protected abstract URL _getHelpURL();

    protected boolean _isDirty() {
        return this._dirty;
    }

    protected void _processButtonPress(String button) {
        if (button.equals("Cancel")) {
            this._cancel();
        } else if (button.equals("Help")) {
            this._showHelp();
        }
    }

    protected void _setDirty(boolean dirty) {
        this._dirty = dirty;
    }

    protected void _showHelp() {
        URL toRead = this._getHelpURL();
        if (toRead != null && this._configuration != null) {
            try {
                this._configuration.openModel(null, toRead, toRead.toExternalForm());
            }
            catch (Exception ex) {
                MessageHandler.error("Help screen failure", ex);
            }
        } else {
            MessageHandler.error("No help available.");
        }
    }

    private JPanel _createButtonsPanel() {
        JPanel _buttons = new JPanel();
        this._createExtendedButtons(_buttons);
        this._helpButton = new JButton("Help");
        _buttons.add(this._helpButton);
        this._cancelButton = new JButton("Cancel");
        _buttons.add(this._cancelButton);
        for (int i = 0; i < _buttons.getComponentCount(); ++i) {
            ((JButton)_buttons.getComponent(i)).addActionListener(this);
        }
        return _buttons;
    }

    private void _deiconify() {
        this.setExtendedState(0);
    }

    private void _iconify() {
        this.setExtendedState(1);
    }
}

