/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JOptionPane;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.ExecutionListener;
import ptolemy.actor.Manager;
import ptolemy.actor.gui.ModelPane;
import ptolemy.actor.gui.PtolemyFrame;
import ptolemy.actor.gui.Tableau;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.Documentation;

public class ModelFrame
extends PtolemyFrame
implements ExecutionListener {
    private ModelPane _pane;
    private Manager.State _previousState;

    public ModelFrame(CompositeActor model) {
        this(model, null);
    }

    public ModelFrame(CompositeActor model, Tableau tableau) {
        this(model, tableau, new ModelPane(model));
    }

    public ModelFrame(CompositeActor model, Tableau tableau, ModelPane pane) {
        super(model, tableau);
        this._pane = pane;
        this.getContentPane().add((Component)this._pane, "Center");
        Manager manager = model.getManager();
        if (manager != null) {
            manager.addExecutionListener(this);
        }
        this._pane.setDefaultButton();
    }

    @Override
    public void executionError(Manager manager, Throwable throwable) {
        this.report(throwable);
    }

    @Override
    public void executionFinished(Manager manager) {
        this.report("execution finished.");
    }

    @Override
    public void managerStateChanged(Manager manager) {
        Manager.State newState = manager.getState();
        if (newState != this._previousState) {
            this.report(manager.getState().getDescription());
            this._previousState = newState;
        }
    }

    public ModelPane modelPane() {
        return this._pane;
    }

    @Override
    public void setBackground(Color background) {
        super.setBackground(background);
        this.getContentPane().setBackground(background);
        if (this._pane != null) {
            this._pane.setBackground(background);
        }
    }

    public void setModel(CompositeActor model) {
        super.setModel(model);
        if (model != null) {
            Manager manager;
            if (this._pane != null) {
                this._pane.setModel(model);
            }
            if ((manager = model.getManager()) != null) {
                manager.addExecutionListener(this);
            }
        }
    }

    @Override
    protected boolean _clear() {
        if (super._clear()) {
            this.setModel(new CompositeActor());
            return true;
        }
        return false;
    }

    @Override
    protected boolean _close() {
        Manager manager;
        boolean result = super._close();
        NamedObj model = this.getModel();
        if (model instanceof CompositeActor && (manager = ((CompositeActor)model).getManager()) != null) {
            manager.removeExecutionListener(this);
        }
        if (this._pane != null) {
            this._pane.stopRun();
            this._pane.windowClosed(this, "");
        }
        return result;
    }

    @Override
    protected void _help() {
        String tip;
        String message = "Ptolemy II model.";
        NamedObj model = this.getModel();
        if (model != null && (tip = Documentation.consolidate(model)) != null) {
            message = "Ptolemy II model:\n" + tip;
        }
        JOptionPane.showMessageDialog(this, message, "About " + this.getTitle(), 1);
    }
}

