/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.util.Set;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.ExpressionShellEffigy;
import ptolemy.actor.gui.ExpressionShellFrame;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtAssignmentNode;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ModelScope;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.Type;
import ptolemy.graph.InequalityTerm;
import ptolemy.gui.ShellInterpreter;
import ptolemy.gui.ShellTextArea;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class ExpressionShellTableau
extends Tableau
implements ShellInterpreter {
    public ExpressionShellFrame frame = new ExpressionShellFrame(this);
    public ShellTextArea shell;
    private ParseTreeEvaluator _evaluator;

    public ExpressionShellTableau(ExpressionShellEffigy container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setFrame(this.frame);
        this.frame.setTableau(this);
        this._evaluator = new ParseTreeEvaluator();
    }

    @Override
    public String evaluateCommand(String command) throws Exception {
        if (command.trim().equals("")) {
            return "";
        }
        PtParser parser = new PtParser();
        ASTPtRootNode node = parser.generateSimpleAssignmentParseTree(command);
        String targetName = null;
        if (node instanceof ASTPtAssignmentNode) {
            ASTPtAssignmentNode assignmentNode = (ASTPtAssignmentNode)node;
            targetName = assignmentNode.getIdentifier();
            node = assignmentNode.getExpressionTree();
        }
        final NamedObj model = ((ExpressionShellEffigy)this.getContainer()).getModel();
        ModelScope scope = new ModelScope(){

            @Override
            public Token get(String name) throws IllegalActionException {
                Variable result = 1.getScopedVariable(null, model, name);
                if (result != null) {
                    return result.getToken();
                }
                return null;
            }

            @Override
            public Type getType(String name) throws IllegalActionException {
                Variable result = 1.getScopedVariable(null, model, name);
                if (result != null) {
                    return result.getType();
                }
                return null;
            }

            @Override
            public InequalityTerm getTypeTerm(String name) throws IllegalActionException {
                Variable result = 1.getScopedVariable(null, model, name);
                if (result != null) {
                    return result.getTypeTerm();
                }
                return null;
            }

            @Override
            public Set identifierSet() {
                return 1.getAllScopedVariableNames(null, model);
            }
        };
        Token result = this._evaluator.evaluateParseTree(node, scope);
        if (targetName != null) {
            Attribute attribute = model.getAttribute(targetName);
            if (attribute != null && !(attribute instanceof Parameter)) {
                attribute.setContainer(null);
                attribute = null;
            }
            if (attribute == null) {
                attribute = new Parameter(model, targetName);
            }
            ((Parameter)attribute).setToken(result);
        }
        if (result == null) {
            return "";
        }
        return result.toString();
    }

    @Override
    public boolean isCommandComplete(String command) {
        return true;
    }

    public static class Factory
    extends TableauFactory {
        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        @Override
        public Tableau createTableau(Effigy effigy) throws Exception {
            if (effigy instanceof ExpressionShellEffigy) {
                return new ExpressionShellTableau((ExpressionShellEffigy)effigy, "ExpressionShellTableau");
            }
            return null;
        }
    }
}

