/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.Manager;
import ptolemy.actor.gui.Placeable;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.attributes.VersionAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.moml.MoMLParser;

public class CompositeActorSimpleApplication {
    protected String[] _commandFlags = new String[]{"-help", "-test", "-version"};
    protected String[][] _commandOptions = new String[][]{{"-class", "<classname>"}, {"-<parameter name>", "<parameter value>"}};
    protected String _commandTemplate = "ptolemy [ options ]";
    protected List _models = new LinkedList();
    protected int _openCount = 0;
    protected static boolean _test = false;
    private boolean _expectingClass = false;
    private List _parameterNames = new LinkedList();
    private List _parameterValues = new LinkedList();

    public static void main(String[] args) {
        CompositeActorSimpleApplication application = new CompositeActorSimpleApplication();
        try {
            application.processArgs(args);
            application.waitForFinish();
        }
        catch (Exception ex) {
            System.err.println(KernelException.stackTraceToString(ex));
            System.exit(0);
        }
        if (_test) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public void processArgs(String[] args) throws Exception {
        if (args != null) {
            this._parseArgs(args);
            Iterator models = this._models.iterator();
            while (models.hasNext()) {
                this.startRun((CompositeActor)models.next());
            }
        }
    }

    public void report(Exception ex) {
        this.report("", ex);
    }

    public void report(String message) {
        System.out.println(message);
    }

    public void report(String message, Exception ex) {
        System.err.println("Exception thrown:\n" + message + "\n" + KernelException.stackTraceToString(ex));
    }

    public synchronized void startRun(CompositeActor model) throws IllegalActionException {
        for (Object object : model.allAtomicEntityList()) {
            if (!(object instanceof Placeable)) continue;
            throw new IllegalActionException("CompositeActorSimpleApplication does not support actors that are instances of placeable, object was: " + object);
        }
        Manager manager = model.getManager();
        if (manager != null) {
            try {
                manager.startRun();
            }
            catch (IllegalActionException ex) {}
        } else {
            this.report("Model " + model.getFullName() + " cannot be executed " + "because it does not have a manager.");
        }
    }

    public void stopRun(CompositeActor model) {
        Manager manager = model.getManager();
        if (manager != null) {
            manager.stop();
        }
    }

    public synchronized void waitForFinish() {
        while (this._openCount > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                break;
            }
        }
    }

    protected boolean _parseArg(String arg) throws Exception {
        if (arg.equals("-class")) {
            this._expectingClass = true;
        } else if (arg.equals("-help")) {
            System.out.println(this._usage());
        } else if (arg.equals("-test")) {
            _test = true;
        } else if (arg.equals("-version")) {
            System.out.println("Version " + VersionAttribute.CURRENT_VERSION + ", Build $Id: CompositeActorSimpleApplication.java,v 1.15 2007/12/07 06:24:58 cxh Exp $");
        } else if (!arg.equals("")) {
            if (this._expectingClass) {
                this._expectingClass = false;
                MoMLParser parser = new MoMLParser();
                String string = "<entity name=\"toplevel\" class=\"" + arg + "\"/>";
                CompositeActor model = (CompositeActor)parser.parse(string);
                CompositeActor modelClass = (CompositeActor)parser.searchForClass(arg, model.getSource());
                if (modelClass != null) {
                    model = modelClass;
                }
                this._models.add(model);
                Manager manager = model.getManager();
                if (manager == null) {
                    model.setManager(new Manager(model.workspace(), "manager"));
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected void _parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this._parseArg(arg)) continue;
            if (arg.startsWith("-") && i < args.length - 1) {
                this._parameterNames.add(arg.substring(1));
                this._parameterValues.add(args[i + 1]);
                ++i;
                continue;
            }
            throw new IllegalActionException("Unrecognized option: " + arg);
        }
        if (this._expectingClass) {
            throw new IllegalActionException("Missing classname.");
        }
        Iterator names = this._parameterNames.iterator();
        Iterator values = this._parameterValues.iterator();
        while (names.hasNext() && values.hasNext()) {
            String name = (String)names.next();
            String value = (String)values.next();
            boolean match = false;
            for (CompositeActor model : this._models) {
                Director director;
                Attribute attribute = model.getAttribute(name);
                if (attribute instanceof Variable) {
                    match = true;
                    ((Variable)attribute).setExpression(value);
                    ((Variable)attribute).getToken();
                }
                if ((director = model.getDirector()) == null || !((attribute = director.getAttribute(name)) instanceof Variable)) continue;
                match = true;
                ((Variable)attribute).setExpression(value);
                ((Variable)attribute).getToken();
            }
            if (match) continue;
            throw new IllegalActionException("Unrecognized option: -" + name);
        }
    }

    protected String _usage() {
        int i;
        String result = "Usage: " + this._commandTemplate + "\n\n" + "Options that take values:\n";
        for (i = 0; i < this._commandOptions.length; ++i) {
            result = result + " " + this._commandOptions[i][0] + " " + this._commandOptions[i][1] + "\n";
        }
        result = result + "\nBoolean flags:\n";
        for (i = 0; i < this._commandFlags.length; ++i) {
            result = result + " " + this._commandFlags[i];
        }
        return result;
    }
}

