/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt.ingredients.criteria;

import ptolemy.actor.Actor;
import ptolemy.actor.gt.GTIngredient;
import ptolemy.actor.gt.GTIngredientElement;
import ptolemy.actor.gt.GTIngredientList;
import ptolemy.actor.gt.ValidationException;
import ptolemy.actor.gt.ingredients.criteria.Criterion;
import ptolemy.actor.gt.ingredients.criteria.CriterionElement;
import ptolemy.actor.gt.ingredients.criteria.StringCriterionElement;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.util.NamedObj;

public class SubclassCriterion
extends Criterion {
    private static final CriterionElement[] _ELEMENTS = new CriterionElement[]{new StringCriterionElement("superclass", false)};
    private String _superclass;

    public SubclassCriterion(GTIngredientList owner) {
        this(owner, "");
    }

    public SubclassCriterion(GTIngredientList owner, String values) {
        super(owner, 1);
        this.setValues(values);
    }

    @Override
    public GTIngredientElement[] getElements() {
        return _ELEMENTS;
    }

    public String getSuperclass() {
        return this._superclass;
    }

    @Override
    public Object getValue(int index) {
        switch (index) {
            case 0: {
                return this._superclass;
            }
        }
        return null;
    }

    @Override
    public String getValues() {
        StringBuffer buffer = new StringBuffer();
        this._encodeStringField(buffer, 0, this._superclass);
        return buffer.toString();
    }

    public boolean isSuperclassEnabled() {
        return this.isEnabled(0);
    }

    @Override
    public GTIngredient.NamedObjMatchResult match(NamedObj object) {
        if (object instanceof ComponentEntity) {
            if (this.isSuperclassEnabled()) {
                try {
                    Class<?> superclass = Class.forName(this.getSuperclass());
                    if (superclass.isInstance(object)) {
                        return GTIngredient.NamedObjMatchResult.MATCH;
                    }
                    return GTIngredient.NamedObjMatchResult.NOT_MATCH;
                }
                catch (ClassNotFoundException e) {
                    return GTIngredient.NamedObjMatchResult.NOT_MATCH;
                }
            }
            return GTIngredient.NamedObjMatchResult.MATCH;
        }
        return GTIngredient.NamedObjMatchResult.UNAPPLICABLE;
    }

    public void setSuperclassEnabled(boolean enabled) {
        this.setEnabled(0, enabled);
    }

    @Override
    public void setValue(int index, Object value) {
        switch (index) {
            case 0: {
                this._superclass = (String)value;
            }
        }
    }

    @Override
    public void setValues(String values) {
        GTIngredient.FieldIterator fieldIterator = new GTIngredient.FieldIterator(values);
        this._superclass = this._decodeStringField(0, fieldIterator);
    }

    @Override
    public void validate() throws ValidationException {
        Class<?> superclass;
        if (this._superclass.equals("")) {
            throw new ValidationException("Superclass name must not be empty.");
        }
        try {
            superclass = Class.forName(this._superclass);
        }
        catch (Throwable t) {
            throw new ValidationException("Cannot load class \"" + this._superclass + "\".", t);
        }
        try {
            superclass.asSubclass(Actor.class);
        }
        catch (Throwable t) {
            throw new ValidationException("Superclass must be a subclass of \"" + Actor.class.getName() + "\".", t);
        }
    }
}

